---
title: "Access Modifiers (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "access modifiers [C#]"
ms.assetid: 61c3fa51-c00f-48cb-9b49-c805dedd62d7
caps.latest.revision: 15
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Access Modifiers (C# Reference)
Access modifiers are keywords used to specify the declared accessibility of a member or a type. This section introduces the four access modifiers:  
  
-   [public](../../../csharp/language-reference/keywords/public.md)  
  
-   [protected](../../../csharp/language-reference/keywords/protected.md)  
  
-   [internal](../../../csharp/language-reference/keywords/internal.md)  
  
-   [private](../../../csharp/language-reference/keywords/private.md)  
  
 The following five accessibility levels can be specified using the access modifiers:  
  
 `public`: Access is not restricted.  
  
 `protected`: Access is limited to the containing class or types derived from the containing class.  
  
 `Internal`: Access is limited to the current assembly.  
  
 [protected internal](../../../csharp/programming-guide/classes-and-structs/access-modifiers.md): Access is limited to the current assembly or types derived from the containing class.  
  
 `private`: Access is limited to the containing type.  
  
 This section also introduces the following:  
  
-   [Accessibility Levels](../../../csharp/language-reference/keywords/accessibility-levels.md): Using the four access modifiers to declare five levels of accessibility.  
  
-   [Accessibility Domain](../../../csharp/language-reference/keywords/accessibility-domain.md): Specifies where, in the program sections, a member can be referenced.  
  
-   [Restrictions on Using Accessibility Levels](../../../csharp/language-reference/keywords/restrictions-on-using-accessibility-levels.md): A summary of the restrictions on using declared accessibility levels.  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)   
 [Access Modifiers](../../../csharp/programming-guide/classes-and-structs/access-modifiers.md)   
 [Access Keywords](../../../csharp/language-reference/keywords/access-keywords.md)   
 [Modifiers](../../../csharp/language-reference/keywords/modifiers.md)