---
title: "Compiler Error CS0026 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
f1_keywords: 
  - "CS0026"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0026"
ms.assetid: 8767fbc1-8ba7-4e88-a9f9-7e620411882b
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0026
Keyword 'this' is not valid in a static property, static method, or static field initializer  
  
 The [this](../../csharp/language-reference/keywords/this.md) keyword refers to an object, which is an instance of a type. Since static methods are independent of any instance of the containing class, the "this" keyword is meaningless and is therefore not allowed. For more information, see [Static Classes and Static Class Members](../../csharp/programming-guide/classes-and-structs/static-classes-and-static-class-members.md) and [Objects](../../csharp/programming-guide/classes-and-structs/objects.md).  
  
## Example  
 The following example generates CS0026:  
  
```  
// CS0026.cs  
public class A  
{  
   public static int i = 0;  
  
   public static void Main()  
   {  
// CS0026  
      this.i = this.i + 1;     
      // Try the following line instead:  
      // i = i + 1;  
   }  
}  
```