---
title: "Compiler Error CS0035 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0035"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0035"
ms.assetid: a622113e-98a4-4583-992c-1fb55139320a
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0035
Operator 'operator' is ambiguous on an operand of type 'type'  
  
 The compiler has more than one available conversion and does not know which to choose before applying the operator. For more information, see [Templated User Defined Conversions](https://docs.microsoft.com/cpp/misc/templated-user-defined-conversions) and [Conversion Operators](../../csharp/programming-guide/statements-expressions-operators/conversion-operators.md).  
  
 The following sample generates CS0035:  
  
```  
// CS0035.cs  
class MyClass  
{  
   private int i;  
  
   public MyClass(int i)  
   {  
      this.i = i;  
   }  
  
   public static implicit operator double(MyClass x)  
   {  
      return (double) x.i;  
   }  
  
   public static implicit operator decimal(MyClass x)  
   {  
      return (decimal) x.i;  
   }  
}  
  
class MyClass2  
{  
   static void Main()  
   {  
      MyClass x = new MyClass(7);  
      object o = - x;   // CS0035  
      // try a cast:  
      // object o = - (double)x;  
   }  
}  
  
```