---
title: "Compiler Error CS0036 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0036"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0036"
ms.assetid: ddbaa36e-473b-4283-a13c-44a71ae5da2e
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0036
An out parameter cannot have the '[In]' attribute  
  
 Currently, the **In** attribute is not permitted on an [out](../../csharp/language-reference/keywords/out.md) parameter.  
  
 The following sample generates CS0036:  
  
```  
// CS0036.cs  
  
using System;  
using System.Runtime.InteropServices;  
  
public class MyClass  
{  
   public static void TestOut([In] out char TestChar)   // CS0036  
   // try the following line instead  
   // public static void TestOut(out char TestChar)  
   {  
      TestChar = 'b';  
      Console.WriteLine(TestChar);  
   }  
  
   public static void Main()  
   {  
      char i;           //variable to receive the value  
      TestOut(out i);   // the arg must be passed as out  
      Console.WriteLine(i);  
   }  
}  
```