---
title: "Compiler Error CS0112 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0112"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0112"
ms.assetid: 6741c7c4-8553-4bbe-b950-4f908e8d9ba3
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0112
A static member 'function' cannot be marked as override, virtual or abstract  
  
 Any method declaration that uses the `override`, **virtual**, or **abstract** keyword cannot also use the **static** keyword.  
  
 For more information, see [Methods](../../csharp/programming-guide/classes-and-structs/methods.md).  
  
 The following sample generates CS0112:  
  
```  
// CS0112.cs  
namespace MyNamespace  
{  
   abstract public class MyClass  
   {  
      public abstract void Foo();  
   }  
   public class MyClass2 : MyClass  
   {  
      override public static void Foo()   // CS0112, remove static keyword  
      {  
      }  
      public static int Main()  
      {  
         return 0;  
      }  
   }  
}  
```