---
title: "Compiler Error CS0121 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0121"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0121"
ms.assetid: 316cb77e-a500-4129-ae1b-e68b9188fd3e
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

---
# Compiler Error CS0121
The call is ambiguous between the following methods or properties: 'method1' and 'method2'  
  
 Due to implicit conversion, the compiler was not able to call one form of an overloaded method. You can resolve this error in the following ways:  
  
-   Specify the method parameters in such a way that implicit conversion does not take place.  
  
-   Remove all overloads for the method.  
  
-   Cast to proper type before calling method.  
  
## Example  
 The following sample generates CS0121:  
  
```  
// CS0121.cs  
public class C  
{  
   void f(int i, double d)   
   {  
   }  
  
   void f(double d, int i)  
   {  
   }  
  
   public static void Main()  
   {  
      C c = new C();  
  
      c.f(1, 1);   // CS0121  
      // try the following line instead  
      // c.f(1, 1.0);  
      // or  
      // c.f(1.0, 1);  
      // or  
      // c.f(1, (double)1);   // cast and specify which method to call  
   }  
}  
```  
  
## Example  
 The following example produces CS0121 in the current version of Visual Studio, but not in Visual Studio 2005:  
  
```  
//CS0121_2.cs  
class Program2  
{  
  
    static int ol_invoked = 0;  
  
    delegate int D1(int x);  
    delegate T D1<T>(T x);  
    delegate T D1<T, U>(U u);  
  
    static void F(D1 d1) { ol_invoked = 1; }  
    static void F<T>(D1<T> d1t) { ol_invoked = 2; }  
    static void F<T, U>(D1<T, U> d1t) { ol_invoked = 3; }  
  
    static int Test001()  
    {  
        F(delegate(int x) { return 1; }); //CS0121  
        if (ol_invoked == 1)  
            return 0;  
        else  
            return 1;  
    }  
  
    static int Main()  
    {  
        return Test001();  
    }  
}  
```