---
title: "Compiler Error CS0150 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0150"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0150"
ms.assetid: 1fd08ca5-e1a9-42f5-93de-2916a3bdcad1
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0150
A constant value is expected  
  
 A variable was found where a constant was expected. For more information, see [switch](../../csharp/language-reference/keywords/switch.md).  
  
 The following sample generates CS0150:  
  
```  
// CS0150.cs  
namespace MyNamespace  
{  
   public class MyClass  
   {  
      public static void Main()  
      {  
         int i = 0;  
         int j = 0;  
  
         switch(i)  
         {  
            case j:   // CS0150, j is a variable int, not a constant int  
            // try the following line instead  
            // case 1:  
         }  
      }  
   }  
}  
```  
  
 This error is also produced when an array size is specified with a variable value and initialized with an array initializer. To remove the error, initialize the array in a separate statement or statements.  
  
```  
// CS0150.cs  
    namespace MyNamespace  
    {  
        public class MyClass  
        {  
            public static void Main()  
            {  
                int size = 2;  
                double[] nums = new double[size] { 46.9, 89.4 }; //CS0150  
                // Try the following lines instead  
                // double[] nums = new double[size];  
                // nums[0] = 46.9;   
                // nums[1] = 89.4;  
            }  
        }  
  
    }  
  
```