---
title: "Compiler Error CS0206 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0206"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0206"
ms.assetid: d2f9838a-d8ae-4342-b8bd-fa5745619a26
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0206
A property or indexer may not be passed as an out or ref parameter  
  
 A [property](../../csharp/programming-guide/classes-and-structs/properties.md) is not available to be passed as a [ref](../../csharp/language-reference/keywords/ref.md) or [out](../../csharp/language-reference/keywords/out.md) parameter. For more information, see [Passing Parameters](../../csharp/programming-guide/classes-and-structs/passing-parameters.md).  
  
## Example  
 The following sample generates CS0206:  
  
```  
// CS0206.cs  
public class MyClass  
{  
    public static int P  
    {  
        get  
        {  
            return 0;  
        }  
        set  
        {  
        }  
    }  
  
    public static void MyMeth(ref int i)  
    // public static void MyMeth(int i)  
    {  
    }  
  
    public static void Main()  
    {  
        MyMeth(ref P);   // CS0206  
        // try the following line instead  
        // MyMeth(P);   // CS0206  
    }  
}  
```