---
title: "Compiler Error CS0308 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0308"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0308"
ms.assetid: b52ef9d2-f5b3-4baf-9a7e-bb1371e79463
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0308
The non-generic type-or-method 'identifier' cannot be used with type arguments.  
  
 The method or type is not generic, but it was used with type arguments. To avoid this error, remove the angled brackets and type arguments, or redeclare the method or type as a generic method or type.  
  
 The following example generates CS0308:  
  
```  
// CS0308a.cs  
class MyClass  
{  
   public void F() {}  
   public static void Main()  
   {  
      F<int>();  // CS0308 – F is not generic.  
      // Try this instead:  
      // F();  
   }  
}  
```  
  
 The following example also generates CS0308. To resolve the error, use the directive "using System.Collections.Generic."  
  
```  
// CS0308b.cs  
// compile with: /t:library  
using System.Collections;  
// To resolve, uncomment the following line:  
// using System.Collections.Generic;  
public class MyStack<T>  
{  
    // Store the elements of the stack:  
    private T[] items = new T[100];  
    private int stack_counter = 0;  
  
    // Define the iterator block:  
    public IEnumerator<T> GetEnumerator()   // CS0308  
    {  
        for (int i = stack_counter - 1 ; i >= 0; i--)  
        yield return items[i];  
    }  
}  
  
```