---
title: "Compiler Warning (level 3) CS0414 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0414"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0414"
ms.assetid: 6a0a80be-799b-4d9c-a7e0-6b91e9ce7be0
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 3) CS0414
The private field 'field' is assigned but its value is never used  
  
 This warning can occur in several scenarios in which the compiler can verify that a variable is never referenced:  
  
-   A private field is assigned a constant value but is never subsequently read. The unnecessary assignment could effect performance. Consider removing the field.  
  
-   A private or internal static field is assigned a constant value only in the initializer. Consider changing the field to a const.  
  
-   A private or internal field is assigned constant values and only used in blocks that are excluded by #ifdef directives. Consider putting the field inside the #ifdef block.  
  
-   A private or internal field is assigned constant values in multiple locations but not otherwise accessed. If you do not need the field, consider removing it. Otherwise, use it in some appropriate way.  
  
 In other situations, or where the suggested workaround is not acceptable, use #pragma 0414.  
  
 The following sample shows one way in which CS0414 will be generated:  
  
```  
// CS0414  
// compile with: /W3  
class C  
{  
   private int i = 1;  // CS0414  
  
   public static void Main()  
   { }  
}  
```  
  
 **Note** If the variable `i` is declared as `protected or public`, no error will be generated because the compiler cannot know whether a derived class might use it or some other client code might instantiate the class and reference the variable  
  
## See Also  
 [C# Compiler Errors](../../csharp/language-reference/compiler-messages/index.md)   
 [C# Compiler Options](../../csharp/language-reference/compiler-options/index.md)