---
title: "Compiler Error CS0431 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0431"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0431"
ms.assetid: 05da7ea7-f33d-48d4-948e-d64be56f91ba
caps.latest.revision: 10
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0431
Cannot use alias 'identifier' with '::' since the alias references a type. Use '.' instead.  
  
 You used "::" with an alias that references a type. To resolve this error, use the "." operator.  
  
 The following sample generates CS0431:  
  
```  
// CS0431.cs  
using A = Outer;  
  
public class Outer   
{  
   public class Inner   
   {  
      public static void Meth() {}  
   }  
}  
  
public class MyClass  
{  
   public static void Main()  
   {  
      A::Inner.Meth();   // CS0431  
      A.Inner.Meth();   // OK  
   }  
}  
```