---
title: "Compiler Error CS0450 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0450"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0450"
ms.assetid: 8eb0e98b-d7a1-49a7-8e55-36e2eb0057ff
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0450
'Type Parameter Name': cannot specify both a constraint class and the 'class' or 'struct' constraint  
  
 If a type parameter is constrained by the struct type constraint, it is logically contradictory for it to also be constrained by a specific class type, since struct and class are mutually exclusive categories. If a type parameter is constrained by a specific class type constraint, then it is by definition constrained by the class type constraint, and so specifying the class type constraint is redundant.  
  
## Example  
  
```  
// CS0450.cs  
// compile with: /t:library  
public class GenericsErrors   
{  
    public class B { }  
    public class G3<T> where T : struct, B { } // CS0450  
// To resolve, use the following line instead:  
// public class G3<T> where T : B { }  
}  
```