---
title: "Compiler Error CS0452 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0452"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0452"
ms.assetid: 50a87734-fe07-4bce-891d-a76e131db6cc
caps.latest.revision: 12
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0452
The type 'type name' must be a reference type in order to use it as parameter 'parameter name' in the generic type or method 'identifier of generic'  
  
 This error occurs when you pass a value type such as a `struct` or `int` as a parameter to a generic type or method that has a reference type constraint.  
  
## Example  
 The following code generates error CS0452.  
  
```  
// CS0452.cs  
using System;  
public class BaseClass<S> where S : class { }  
public class Derived1 : BaseClass<int> { } // CS0452  
public class Derived2<S> : BaseClass<S> where S : struct { } // CS0452  
```  
  
## See Also  
 [Constraints on Type Parameters](../../csharp/programming-guide/generics/constraints-on-type-parameters.md)