---
title: "Compiler Error CS0462 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0462"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0462"
ms.assetid: 0732b12d-0f7a-47d5-bc54-8b6147d7249f
caps.latest.revision: 16
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0462
The inherited members 'member1' and 'member2' have the same signature in type 'type', so they cannot be overridden  
  
 This error arises with the introduction of generics. Normally, you cannot have two versions of a method in a class with the same signature. But with generics, you can specify a generic method that might duplicate another method if it is instantiated with a particular type.  
  
## Example  
 When `C<int>` is instantiated, two versions of the method `F` are created with the same signature, so the override in class `D` cannot decide which one to apply the override to.  
  
 The following sample generates CS0462.  
  
```  
// CS0462.cs  
// compile with: /target:library  
class C<T>   
{  
   public virtual void F(T t) {}  
   public virtual void F(int t) {}  
}  
  
class D : C<int>   
{  
   public override void F(int t) {}   // CS0462  
}  
```