---
title: "Compiler Error CS0601 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0601"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0601"
ms.assetid: 20666d6f-e435-4f2d-8eca-084b7d6b57d8
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0601
The DllImport attribute must be specified on a method marked 'static' and 'extern'  
  
 The `DllImport` attribute was used on a method that did not have the correct access keywords.  
  
 The following sample generates CS0601:  
  
```  
// CS0601.cs  
using System.Runtime.InteropServices;  
using System.Text;  
  
public class C  
{  
   [DllImport("KERNEL32.DLL")]  
   extern int GetCurDirectory(int bufSize, StringBuilder buf);   // CS0601  
   // Try the following line instead:  
   // static extern int GetCurDirectory(int bufSize, StringBuilder buf);  
}  
  
public class MainClass  
{  
   public static void Main ()  
   {  
   }  
}  
```