---
title: "Compiler Warning (level 1) CS0688 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0688"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0688"
ms.assetid: 8ce5af36-663e-46e8-87e9-bb32555796ae
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 1) CS0688
'method1' has a link demand, but overrides or implements 'method2' which does not have a link demand. A security hole may exist.  
  
 The link demand set up on the derived class method can easily be circumvented by calling the base class method. To close the security hole, the base class method needs to also use the link demand. For more information, see [Demand vs. LinkDemand](http://msdn.microsoft.com/en-us/1ab877f2-70f4-4e0d-8116-943999dfe8f5).  
  
## Example  
 The following sample generates CS0688. To resolve the warning without modifying the base class, remove the security attribute from the overriding method. This will not solve the security problem.  
  
```  
// CS0688.cs  
// compile with: /W:1  
using System;  
using System.Security.Permissions;  
  
class Base   
{  
    //Uncomment the following line to close the security hole  
    //[FileIOPermission(SecurityAction.LinkDemand, All=@"C:\\")]  
    public virtual void DoScaryFileStuff()  
    {  
    }  
}  
  
class Derived: Base  
{  
    [FileIOPermission(SecurityAction.LinkDemand, All=@"C:\\")] // CS0688  
    public override void DoScaryFileStuff()  
    {  
    }  
    static void Main()  
    {  
    }  
}  
```