---
title: "Compiler Error CS0738 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0738"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0738"
ms.assetid: 01ce94ee-2435-4326-befc-2b020c441a4f
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0738
'type name' does not implement interface member 'member name'. 'method name' cannot implement 'interface member' because it does not have the matching return type of ' type name'.  
  
 The return value of an implementing method in a class must match the return value of the interface member that it implements.  
  
## To correct this error  
  
1.  Change the return type of the method to match that of the interface member.  
  
## Example  
 The following code generates CS0738 because the class method returns `void` and the interface member of the same name returns `int`:  
  
```  
using System;  
  
interface ITest  
{  
    int TestMethod();  
}  
public class Test: ITest  
{  
    public void TestMethod() { } // CS0738  
    // Try the following line instead.  
    // public int TestMethod();  
}  
```  
  
## See Also  
 [Interfaces](../../csharp/programming-guide/interfaces/index.md)