---
title: "Compiler Error CS0754 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0754"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0754"
ms.assetid: c83e04b5-6ab5-45c2-805e-0ba4f041d506
caps.latest.revision: 5
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0754
A partial method may not explicitly implement an interface method.  
  
 A partial method cannot be declared as an explicit implementation of a method defined in an interface.  
  
## To correct this error  
  
1.  Remove the explicit interface qualification from the method declaration.  
  
## Example  
 The following code generates CS0754:  
  
```  
// cs0754.cs  
using System;  
  
    public interface IF  
    {  
        void Part();  
    }  
  
    public partial class C : IF  
    {  
        partial void IF.Part(); //CS0754  
        public static int Main()  
        {  
            return 1;  
        }  
    }  
```  
  
## See Also  
 [Explicit Interface Implementation](../../csharp/programming-guide/interfaces/explicit-interface-implementation.md)   
 [Partial Classes and Methods](../../csharp/programming-guide/classes-and-structs/partial-classes-and-methods.md)