---
title: "Compiler Error CS1511 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1511"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1511"
ms.assetid: c04b5268-5bc3-41db-af6b-463ab1d802b4
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1511
Keyword 'base' is not available in a static method  
  
 The [base](../../csharp/language-reference/keywords/base.md) keyword was used in a [static](../../csharp/language-reference/keywords/static.md) method. `base` can only be called in an instance constructor, instance method, or instance accessor.  
  
## Example  
 The following sample generates CS1511.  
  
```  
// CS1511.cs  
// compile with: /target:library  
public class A  
{  
   public int j = 0;  
}  
  
class C : A  
{  
   public void Method()  
   {  
      base.j = 3;   // base allowed here  
   }  
  
   public static int StaticMethod()  
   {  
      base.j = 3;   // CS1511  
      return 1;  
   }  
}  
```