---
title: "Compiler Error CS1520 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1520"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1520"
ms.assetid: 1aeeee83-52a6-45dc-b197-a9a6de3a220c
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1520
Method must have a return type  
  
 A method that is declared in a class, struct, or interface must have an explicit return type. In the following example, the Square method has a return value of [string](../../csharp/language-reference/keywords/string.md):  
  
```  
class Test  
{  
    string IntToString(int i)  
    {  
        return i.ToString();  
    }  
}  
```  
  
 The following sample generates CS1520:  
  
```  
// CS1520a.cs  
public class x  
{  
   // Method declaration missing a return type  
   MyMethod()   // CS1520     
   {}  
   // Add the desired return type:  
   // void MyMethod2()  
  // { }  
  
   public static void Main()  
   {  
   }  
}  
```  
  
 Alternatively, this error might be encountered when the case of a constructor's name differs from that of the class or struct declaration, as in the following sample. Because the name is not exactly the same as the class name, the compiler interprets it as a regular method, not a constructor, and produces the error:  
  
```  
// CS1520b.cs  
public class Class1  
{  
   // Should be Class1, not class1  
   public class1()   // CS1520  
   {  
   }  
   static void Main()  
   {  
   }  
}  
```  
  
## See Also  
 [Methods](../../csharp/programming-guide/classes-and-structs/methods.md)   
 [Constructors](../../csharp/programming-guide/classes-and-structs/constructors.md)