---
title: "Compiler Error CS1594 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1594"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1594"
ms.assetid: f949a992-27a3-470d-b512-e590e5170af3
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1594
Delegate 'delegate' has some invalid arguments  
  
 The type of an argument passed to a [delegate](../../csharp/language-reference/keywords/delegate.md) invocation does not agree with the type of the parameter in the delegate declaration.  
  
 The following sample generates CS1594:  
  
```  
// CS1594.cs  
using System;  
delegate string func(int i);   // declare delegate  
  
class a  
{  
   public static void Main()  
   {  
      func dt = new func(z);  
      x(dt);  
   }  
  
   public static string z(int j)  
   {  
      Console.WriteLine(j);  
      return j.ToString();  
   }  
  
   public static void x(func hello)  
   {  
      hello("8");   // CS1594  
      // try the following line instead  
      // hello(8);  
   }  
}  
```