---
title: "Compiler Error CS1918 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1918"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1918"
ms.assetid: 9ad2cbbd-3c10-4d56-b4cd-385103d005d4
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1918
Members of property 'name' of type 'type' cannot be assigned with an object initializer because it is of a value type.  
  
 This error occurs when you try to use an object initializer to initialize the properties of a struct type that is itself a property of the class that is being initialized.  
  
## To correct this error  
  
1.  If you must fully initialize the fields of the property in the object initializer, change the struct to a class type. Otherwise, initialize the struct members in a separate method call after you create the object by using the object initializer.  
  
## Example  
 The following example generates CS1918:  
  
```  
// cs1918.cs  
public struct MyStruct  
{  
    public int i;  
  
}  
public class Test  
{  
    private MyStruct str = new MyStruct();  
    public MyStruct Str  
    {  
        get  
        {  
            return str;  
        }  
    }  
    public static int Main()  
    {  
        Test t = new Test { Str = { i = 1 } }; // CS1918  
        return 0;  
    }  
}  
  
```  
  
## See Also  
 [Object and Collection Initializers](../../csharp/programming-guide/classes-and-structs/object-and-collection-initializers.md)