---
title: "Compiler Error CS1938 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1938"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1938"
ms.assetid: fc8de996-f7a1-46e8-b07b-aea520b391b9
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1938
The name 'name' is not in scope on the right side of 'equals'. Consider swapping the expressions on either side of 'equals'.  
  
 The `equals` keyword is a special operator that is used in a `join` clause to determine equality between two expressions. The range variable for the left side source sequence is in scope on the left side of equals, and the range variable for the right side source is only in scope on the left side of equals. You can verify this by experimenting with IntelliSense in the following code example.  
  
## To correct this error  
  
1.  Swap the position of the two range variables as shown in the commented line in the following example:  
  
## Example  
 The following code generates CS1938:  
  
```  
// cs1938.cs  
using System.Linq;  
class Test  
{  
    static void Main()  
    {  
        int[] sourceA = { 1, 2, 3, 4, 5 };  
        int[] sourceB = { 3, 4, 5, 6, 7 };  
  
        var query = from a in sourceA  
                    join b in sourceB on b equals a // CS1938  
                    // Try the following line instead.  
                    // join b in sourceB on a equals b  
                    select new { a, b };  
    }  
}  
```  
  
## See Also  
 [join clause](../../csharp/language-reference/keywords/join-clause.md)