---
title: "Compiler Warning (level 1) CS3005 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS3005"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS3005"
ms.assetid: 64b687e3-2dbd-45dd-b6da-81f77eb7d6bd
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 1) CS3005
Identifier 'identifier' differing only in case is not CLS-compliant  
  
 A [public](../../csharp/language-reference/keywords/public.md), [protected](../../csharp/language-reference/keywords/protected.md), or `protected``internal` identifier, which differs from another `public`, `protected`, or `protected``internal` identifier only in the case of one or more letters, is not compliant with the Common Language Specification (CLS). For more information on CLS Compliance, see [Writing CLS-Compliant Code](http://msdn.microsoft.com/en-us/4c705105-69a2-4e5e-b24e-0633bc32c7f3) and [Language Independence and Language-Independent Components](https://msdn.microsoft.com/library/12a7a7h3).  
  
## Example  
 The following example generates CS3003:  
  
```  
// CS3005.cs  
  
using System;  
  
[assembly:CLSCompliant(true)]  
public class a  
{  
    public static int a1 = 0;  
    public static int A1 = 1;   // CS3005  
  
    public static void Main()  
    {  
        Console.WriteLine(a1);  
        Console.WriteLine(A1);  
    }  
}  
```