---
title: "Compiler Warning (level 2) CS3019 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS3019"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS3019"
ms.assetid: b41117cf-8956-4989-93fd-9903812e2d2f
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Warning (level 2) CS3019
CLS compliance checking will not be performed on 'type' because it is not visible from outside this assembly.  
  
 This warning occurs when a type or a member that has the <xref:System.CLSCompliantAttribute> attribute is not visible from another assembly. To resolve this error, remove the attribute on any classes or members that are not visible from the other assembly, or make the type or members visible. For more information on CLS Compliance, see [\<PAVE OVER> Writing CLS-Compliant Code](http://msdn.microsoft.com/en-us/4c705105-69a2-4e5e-b24e-0633bc32c7f3).  
  
## Example  
 The following sample generates CS3019:  
  
```  
// CS3019.cs  
// compile with: /W:2  
  
using System;  
  
[assembly: CLSCompliant(true)]  
  
// To fix the error, remove the next line  
[CLSCompliant(true)]  // CS3019  
class C  
{  
    [CLSCompliant(false)]  // CS3019  
    void Foo()  
    {  
    }  
  
    static void Main()  
    {  
    }  
}  
```  
  
## See Also  
 [Language Independence and Language-Independent Components](https://msdn.microsoft.com/library/12a7a7h3)