---
title: "Statements, Expressions, and Operators (C# Programming Guide) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "expressions [C#]"
  - "operators [C#]"
  - "C# language, statements"
  - "C# language, operators"
  - "C# language, expressions"
  - "statements [C#]"
ms.assetid: 20f8469d-5a6a-4084-ad90-0856b7e97e45
caps.latest.revision: 22
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Statements, Expressions, and Operators (C# Programming Guide)
The C# code that comprises an application consists of statements made up of keywords, expressions and operators. This section contains information regarding these fundamental elements of a C# program.  
  
 For more information, see:  
  
-   [Statements](../../../csharp/programming-guide/statements-expressions-operators/statements.md)  
  
-   [Expressions](../../../csharp/programming-guide/statements-expressions-operators/expressions.md)  
  
-   [Operators](../../../csharp/programming-guide/statements-expressions-operators/operators.md)  
  
-   [Anonymous Functions](../../../csharp/programming-guide/statements-expressions-operators/anonymous-functions.md)  
  
-   [Overloadable Operators](../../../csharp/programming-guide/statements-expressions-operators/overloadable-operators.md)  
  
-   [Conversion Operators](../../../csharp/programming-guide/statements-expressions-operators/conversion-operators.md)  
  
    -   [Using Conversion Operators](../../../csharp/programming-guide/statements-expressions-operators/using-conversion-operators.md)  
  
    -   [How to: Implement User-Defined Conversions Between Structs](../../../csharp/programming-guide/statements-expressions-operators/how-to-implement-user-defined-conversions-between-structs.md)  
  
-   [How to: Use Operator Overloading to Create a Complex Number Class](../../../csharp/programming-guide/statements-expressions-operators/how-to-use-operator-overloading-to-create-a-complex-number-class.md)  
  
-   [Equality Comparisons](../../../csharp/programming-guide/statements-expressions-operators/equality-comparisons.md)  
  
## C# Language Specification  
 [!INCLUDE[CSharplangspec](../../../csharp/language-reference/keywords/includes/csharplangspec_md.md)]  
  
## See Also  
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [Casting and Type Conversions](../../../csharp/programming-guide/types/casting-and-type-conversions.md)