# [Welcome](welcome.md)

<!-- Start of .NET Platform Guide -->
# [.NET Platform Guide](standard/index.md)
## [Getting Started with .NET](standard/getting-started.md)
## [Tour of .NET](standard/tour.md)
## [.NET Architectural Components](standard/components.md)
## [.NET Standard Library](standard/library.md)
## [Frameworks and Targets](standard/frameworks.md)
## [Choosing between .NET Core and .NET Framework for server apps](standard/choosing-core-framework-server.md)
## [What is "managed code"?](standard/managed-code.md)
## [Common Language Runtime (CLR)](standard/clr.md)
## [Language Independence](standard/language-independence.md)
## [Framework Libraries](standard/framework-libraries.md)
## [.NET Class libraries](standard/class-libraries.md)
## [Portability Analyzer](standard/portability-analyzer.md)
## [Handling and throwing exceptions](standard/exceptions.md)
## [.NET Assembly File Format](standard/assembly-format.md)
## [Garbage collection](standard/garbagecollection/index.md)
### [Automatic memory management and garbage collection](standard/garbagecollection/gc.md)
### [Fundamentals of garbage collection](standard/garbagecollection/fundamentals.md)
### [Induced collections](standard/garbagecollection/induced.md)
### [Latency modes](standard/garbagecollection/latency.md)
### [Weak references](standard/garbagecollection/weak-references.md)
### [Cleaning up unmanaged resources](standard/garbagecollection/unmanaged.md)
### [Implementing a dispose method](standard/garbagecollection/implementing-dispose.md)
### [Using objects that implement IDisposable](standard/garbagecollection/using-objects.md)
## [Generic types](standard/generics.md)
## [Working with base types](standard/base-types/index.md)
### [Common type system in depth](standard/base-types/common-type-system.md)
### [Type conversion](standard/base-types/type-conversion.md)
#### [Type conversion tables](standard/base-types/conversion-tables.md)
### [Formatting types](standard/base-types/formatting-types.md)
#### [Standard numeric format strings](standard/base-types/standard-numeric.md)
#### [Custom numeric format strings](standard/base-types/custom-numeric.md)
#### [Standard date and time format strings](standard/base-types/standard-datetime.md)
#### [Custom date and time format strings](standard/base-types/custom-datetime.md)
#### [Standard TimeSpan format strings](standard/base-types/standard-timespan.md)
#### [Custom TimeSpan format strings](standard/base-types/custom-timespan.md)
#### [Enumeration format strings](standard/base-types/enumeration-format.md)
#### [Composite formatting](standard/base-types/composite-format.md)
#### [Performing formatting operations](standard/base-types/performing-formatting-operations.md)
##### [How to: pad a number with leading zeros](standard/base-types/pad-number.md)
##### [How to: extract the day of the week from a specific date](standard/base-types/extract-day.md)
##### [How to: define and use custom numeric format providers](standard/base-types/define-custom.md)
##### [How to: round-trip date and time values](standard/base-types/roundtrip.md)
##### [How to: display milliseconds in date and time values](standard/base-types/display-milliseconds.md)
##### [How to: display dates in non-gregorian calendars](standard/base-types/display-dates.md)
### [Manipulating strings](standard/base-types/manipulating-strings.md)
#### [Best practices for using strings](standard/base-types/best-practices-strings.md)
#### [Basic string operations](standard/base-types/basic-string-operations.md)
##### [Creating new strings](standard/base-types/creating-new.md)
##### [Trimming and removing characters from strings](standard/base-types/trimming.md)
##### [Padding strings](standard/base-types/padding.md)
##### [Comparing strings](standard/base-types/comparing.md)
##### [Changing case](standard/base-types/changing-case.md)
##### [Using the StringBuilder class](standard/base-types/stringbuilder.md)
##### [How to: perform basic string manipulations](standard/base-types/basic-manipulations.md)
### [Regular expressions](standard/base-types/regular-expressions.md)
#### [Regular expression language - quick reference](standard/base-types/quick-ref.md)
##### [Character escapes](standard/base-types/escapes.md)
##### [Character classes](standard/base-types/classes.md)
##### [Anchors](standard/base-types/anchors.md)
##### [Grouping](standard/base-types/grouping.md)
##### [Quantifiers](standard/base-types/quantifiers.md)
##### [Backreference constructs](standard/base-types/backreference.md)
##### [Alternation constructs](standard/base-types/alternation.md)
##### [Substitutions](standard/base-types/substitutions.md)
##### [Regular expression options](standard/base-types/options.md)
##### [Miscellaneous constructs in regular expressions](standard/base-types/miscellaneous.md)
#### [Best practices for regular expressions](standard/base-types/best-practices.md)
#### [The regular expression object model](standard/base-types/object-model.md)
#### [Details of regular expression behavior](standard/base-types/regex-behavior.md)
##### [Backtracking in regular expressions](standard/base-types/backtracking.md)
##### [Compilation and reuse in regular expressions](standard/base-types/compilation.md)
##### [Thread safety in regular expressions](standard/base-types/thread-safety.md)
#### [Regular expression examples](standard/base-types/regex-examples.md)
##### [Regular expression example: scanning for HREFs](standard/base-types/scanning.md)
##### [Regular expression example: changing date formats](standard/base-types/changing-formats.md)
##### [How to: extract a protocol and port number from a URL](standard/base-types/extract-protocol.md)
##### [How to: strip invalid characters from a string](standard/base-types/strip-characters.md)
##### [How to: verify that strings are in valid email format](standard/base-types/verify-format.md)
#### [Character encoding](standard/base-types/character-encoding.md)
#### [Parsing strings](standard/base-types/parsing-strings.md)
##### [Parsing numeric strings](standard/base-types/parsing-numeric.md)
##### [Parsing date and time strings](standard/base-types/parsing-datetime.md)
##### [Parsing other strings](standard/base-types/parsing-other.md)
## [Delegates and lambdas](standard/delegates-lambdas.md)
## [LINQ](standard/using-linq.md)
## [Common Type System & Common Language Specification](standard/common-type-system.md)
## [Asynchronous programming](standard/async.md)
### [Asynchronous programming in depth](standard/async-in-depth.md)
## [Native interoperability](standard/native-interop.md)
## [Collections and Data Structures](standard/collections/index.md)
### [Selecting a Collection Class](standard/collections/selecting-a-collection-class.md)
### [Commonly Used Collection Types](standard/collections/commonly-used-collection-types.md)
### [When to Use Generic Collections](standard/collections/when-to-use-generic-collections.md)
### [Comparisons and Sorts Within Collections](standard/collections/comparisons-and-sorts-within-collections.md)
### [Sorted Collection Types](standard/collections/sorted-collection-types.md)
### [Hashtable and Dictionary Collection Types](standard/collections/hashtable-and-dictionary-collection-types.md)
### [Thread-Safe Collections](standard/collections/threadsafe/index.md)
#### [BlockingCollection Overview](standard/collections/threadsafe/blockingcollection-overview.md)
#### [When to Use a Thread-Safe Collection](standard/collections/threadsafe/when-to-use-a-thread-safe-collection.md)
#### [How to: Add and Remove Items from a ConcurrentDictionary](standard/collections/threadsafe/how-to-add-and-remove-items.md)
#### [How to: Add and Take Items Individually from a BlockingCollection](standard/collections/threadsafe/how-to-add-and-take-items.md)
#### [How to: Add Bounding and Blocking Functionality to a Collection](standard/collections/threadsafe/how-to-add-bounding-and-blocking.md)
#### [How to: Use ForEach to Remove Items in a BlockingCollection](standard/collections/threadsafe/how-to-use-foreach-to-remove.md)
#### [How to: Use Arrays of Blocking Collections in a Pipeline](standard/collections/threadsafe/how-to-use-arrays-of-blockingcollections.md)
#### [How to: Create an Object Pool by Using a ConcurrentBag](standard/collections/threadsafe/how-to-create-an-object-pool.md)
## [Numerics in .NET Core](standard/numerics.md)
## [Dates, times, and time zones](standard/datetime/index.md)
### [Time zone overview](standard/datetime/time-zone-overview.md)
### [Choosing between DateTime, DateTimeOffset, TimeSpan, and TimeZoneInfo](standard/datetime/choosing-between-datetime.md)
### [Finding the time zones defined on a local system](standard/datetime/finding-the-time-zones-on-local-system.md)
### [How to: enumerate time zones present on a computer](standard/datetime/enumerate-time-zones.md)
### [How to: access the predefined UTC and local time zone objects](standard/datetime/access-utc-and-local.md)
### [How to: instantiate a TimeZoneInfo object](standard/datetime/instantiate-time-zone-info.md)
### [Instantiating a DateTimeOffset object](standard/datetime/instantiating-a-datetimeoffset-object.md)
### [Performing arithmetic operations with dates and times](standard/datetime/performing-arithmetic-operations.md)
### [How to: use time zones in date and time arithmetic](standard/datetime/use-time-zones-in-arithmetic.md)
### [Converting between DateTime and DateTimeOffset](standard/datetime/converting-between-datetime-and-offset.md)
### [Converting times between time zones](standard/datetime/converting-between-time-zones.md)
### [How to: resolve ambiguous times](standard/datetime/resolve-ambiguous-times.md)
### [How to: let users resolve ambiguous times](standard/datetime/let-users-resolve-ambiguous-times.md)

<!-- End of .NET Platform Guide -->

<!-- .NET Core Content -->
# [.NET Core Guide](core/index.md)
## [Getting started](core/getting-started.md)
## [Windows Prerequisites](core/windows-prerequisites.md)
## [Tutorials](core/tutorials/index.md)
### [Building a complete .NET Core solution on Windows, using Visual Studio 2017](core/tutorials/using-on-windows-full-solution.md)
### [Getting started with .NET Core on macOS](core/tutorials/using-on-macos.md)
### [Getting started with .NET Core using the CLI tools](core/tutorials/using-with-xplat-cli.md)
#### [Organizing and testing projects with the .NET Core command line](core/tutorials/testing-with-cli.md)
### [Developing Libraries with Cross Platform Tools](core/tutorials/libraries.md)
### [Developing ASP.NET Core applications](core/tutorials/aspnet-core.md)
### [How to Manage Package Dependency Versions for .NET Core 1.0](core/tutorials/managing-package-dependency-versions.md)
### [Hosting .NET Core from native code](core/tutorials/netcore-hosting.md)
## [Packages, Metapackages and Frameworks](core/packages.md)
## Migration
### [Migration to csproj format](core/migration/index.md)
### [Migrating from DNX](core/migration/from-dnx.md)
## [Application Deployment](core/deploying/index.md)
### [Creating a NuGet Package with Cross Platform Tools](core/deploying/creating-nuget-packages.md)
## [Docker](core/docker/index.md)
### [Building Docker Images for .NET Core Applications](core/docker/building-net-docker-images.md)
### [Visual Studio Tools for Docker](core/docker/visual-studio-tools-for-docker.md)
## [Unit Testing](core/testing/index.md)
### [Unit testing with dotnet test and xUnit](core/testing/unit-testing-with-dotnet-test.md)
### [Unit testing with dotnet test and MSTest](core/testing/unit-testing-with-mstest.md)
## [Versioning](core/versions/index.md)
### [.NET Core Support](core/versions/lts-current.md)
### [🔧 Servicing](core/versions/servicing.md)
## [Runtime IDentifier catalog](core/rid-catalog.md)
## [.NET Core Tools](core/tools/index.md)
### [Changes in CLI overview](core/tools/cli-msbuild-architecture.md)
### [Dependency management](core/tools/dependencies.md)
### [Deploying applications](core/deploying/index.md)
### [Additions to the csproj format](core/tools/csproj.md)
### [Mapping between project.json and csproj](core/tools/project-json-to-csproj.md)
### [Telemetry](core/tools/telemetry.md)
### [Extensibility Model](core/tools/extensibility.md)
### [Continuous Integration](core/tools/using-ci-with-cli.md)
### [dotnet](core/tools/dotnet.md)
### [dotnet-build](core/tools/dotnet-build.md)
### [dotnet-clean](core/tools/dotnet-clean.md)
### [dotnet-install-script](core/tools/dotnet-install-script.md)
### [dotnet-migrate](core/tools/dotnet-migrate.md)
### [dotnet-msbuild](core/tools/dotnet-msbuild.md)
### [dotnet-new](core/tools/dotnet-new.md)
### [dotnet-nuget-delete](core/tools/dotnet-nuget-delete.md)
### [dotnet-nuget-locals](core/tools/dotnet-nuget-locals.md)
### [dotnet-nuget-push](core/tools/dotnet-nuget-push.md)
### [dotnet-pack](core/tools/dotnet-pack.md)
### [dotnet-publish](core/tools/dotnet-publish.md)
### [dotnet-restore](core/tools/dotnet-restore.md)
### [dotnet-run](core/tools/dotnet-run.md)
### [dotnet-sln](core/tools/dotnet-sln.md)
### [dotnet-test](core/tools/dotnet-test.md)
### Project modification commands
#### References
##### [dotnet-add-reference](core/tools/dotnet-add-reference.md)
##### [dotnet-list-reference](core/tools/dotnet-list-reference.md)
##### [dotnet-remove-reference](core/tools/dotnet-remove-reference.md)
#### Packages
##### [dotnet-add-package](core/tools/dotnet-add-package.md)
##### [dotnet-remove-package](core/tools/dotnet-remove-package.md)
### [global.json](core/tools/global-json.md)
## [Porting from .NET Framework](core/porting/index.md)
### [Organizing projects for .NET Core](core/porting/project-structure.md)
### [Analyzing third-party dependencies](core/porting/third-party-deps.md)
### [Porting libraries](core/porting/libraries.md)
### [🔧 NuGet packages](core/porting/nuget-packages.md)
<!-- End .NET Core Content -->

<!-- .NET Framework Content -->
# [.NET Framework on Docker Guide](framework/index.md)
## [Docker](framework/docker/index.md)
### [Running Console Apps in Containers](framework/docker/console.md)
<!-- End .NET Framework Content -->

<!-- Start of C# Content -->
# [C# Guide](csharp/index.md)
## [Getting Started](csharp/getting-started/)
## [Tutorials](csharp/tutorials/)
## [Tour of C#](csharp/tour-of-csharp/)
<!-- The "What's New" section is short, and one level
    deep, so leave it in the main TOC -->
## [What's new in C#](csharp/whats-new.md) 
### [What's new in C# 7](csharp/csharp-7.md)
### [What's new in C# 6](csharp/csharp-6.md)
<!-- End What's New -->
## [🔧 C# Interactive](csharp/interactive/)
<!-- Do this section later, once master redirects are in place -->
## [C# Concepts](csharp/concepts.md)
### [C# Type system](csharp/programming-guide/types/index.md)
### [Namespaces](csharp/programming-guide/namespaces/index.md)
### [Basic Types](csharp/basic-types.md)
### [Classes](csharp/classes.md)
### [Structs](csharp/structs.md)
### [Tuples](csharp/tuples.md)
### [Interfaces](csharp/programming-guide/interfaces/index.md)
### [Methods and Lambda Expressions](csharp/methods-lambda-expressions.md)
#### [Methods](csharp/methods.md)
#### [Lambda Expressions](csharp/lambda-expressions.md)
### [Properties](csharp/properties.md)
### [Indexers](csharp/indexers.md)
### [Generics](csharp/programming-guide/generics/index.md)
### [Iterators](csharp/iterators.md)
### [Delegates & events](csharp/delegates-events.md)
#### [Introduction to Delegates](csharp/delegates-overview.md)
#### [System.Delegate and the delegate keyword](csharp/delegate-class.md)
#### [Strongly Typed Delegates](csharp/delegates-strongly-typed.md)
#### [Common Patterns for Delegates](csharp/delegates-patterns.md)
#### [Introduction to Events](csharp/events-overview.md)
#### [The .NET Event Pattern](csharp/event-pattern.md)
#### [The Updated .NET Event Pattern](csharp/modern-events.md)
#### [Distinguishing Delegates and Events](csharp/distinguish-delegates-events.md)
### [Language Integrated Query (LINQ)](csharp/linq/)
### [Asynchronous programming](csharp/async.md)
### [🔧 Parallel programming](csharp/parallel.md)
### [Pattern Matching](csharp/pattern-matching.md)
### [Expression Trees](csharp/expression-trees.md)
#### [Expression Trees Explained](csharp/expression-trees-explained.md)
#### [Framework Types Supporting Expression Trees](csharp/expression-classes.md)
#### [Executing Expressions](csharp/expression-trees-execution.md)
#### [Interpreting Expressions](csharp/expression-trees-interpreting.md)
#### [Building Expressions](csharp/expression-trees-building.md)
#### [Translating Expressions](csharp/expression-trees-translating.md)
#### [Summary](csharp/expression-trees-summary.md)
### [Native interoperability](csharp/programming-guide/interop/index.md)
### [🔧 Reflection & code generation](csharp/reflection.md)
### [Documenting your code](csharp/codedoc.md)
### [Versioning](csharp/versioning.md)
<!-- End of C# Concepts section -->
## [🔧 Using the .NET Compiler Platform](csharp/roslyn/index.md)
## [C# Programming Guide](csharp/programming-guide/)
## [Language Reference](csharp/language-reference/)
## [Walkthroughs](csharp/walkthroughs.md)
<!-- End of C# Content -->

<!-- F# Content -->
# [F# Guide](fsharp/index.md)

## [Tour of F#](fsharp/tour.md)

## [Introduction to Functional Programming](fsharp/introduction-to-functional-programming/index.md)
### [Functions as First-Class Values](fsharp/introduction-to-functional-programming/functions-as-first-class-values.md)

## [Tutorials](fsharp/tutorials/index.md)
### [Getting Started](fsharp/tutorials/getting-started/index.md)
#### [Getting Started with Visual Studio](fsharp/tutorials/getting-started/getting-started-visual-studio.md)
#### [Getting Started with Visual Studio Code and Ionide](fsharp/tutorials/getting-started/getting-started-vscode.md)
#### [Getting Started with Command-line Tools](fsharp/tutorials/getting-started/getting-started-command-line.md)
### [F# Interactive](fsharp/tutorials/fsharp-interactive/index.md)
#### [F# Interactive Options](fsharp/tutorials/fsharp-interactive/fsharp-interactive-options.md)
### [Type Providers](fsharp/tutorials/type-providers/index.md)
#### [Accessing a SQL Database by Using Type Providers](fsharp/tutorials/type-providers/accessing-a-sql-database.md)
#### [Accessing a SQL Database by Using Type Providers and Entities](fsharp/tutorials/type-providers/accessing-a-sql-database-entities.md)
#### [Accessing an OData Service by Using Type Providers](fsharp/tutorials/type-providers/accessing-an-odata-service.md)
#### [Accessing a Web Service Using Type Providers](fsharp/tutorials/type-providers/accessing-a-web-service.md)
#### [Generating F# Types from a DBML File](fsharp/tutorials/type-providers/generating-fsharp-types-from-dbml.md)
#### [Generating F# Types from an EDMX File](fsharp/tutorials/type-providers/generating-fsharp-types-from-edmx.md)
#### [Creating a Type Provider](fsharp/tutorials/type-providers/creating-a-type-provider.md)
#### [Type provider Security](fsharp/tutorials/type-providers/type-provider-security.md)
#### [Troubleshooting Type Providers](fsharp/tutorials/type-providers/troubleshooting-type-providers.md)
### [Asynchronous and Concurrent Programming](fsharp/tutorials/asynchronous-and-concurrent-programming/index.md)
#### [Asynchronous Programming](fsharp/tutorials/asynchronous-and-concurrent-programming/async.md)

## [Using F# in Visual Studio](fsharp/using-fsharp-in-visual-studio/index.md)
### [Visual F# Development Environment Features](fsharp/using-fsharp-in-visual-studio/visual-fsharp-development-environment-features.md)
### [Configuring Projects](fsharp/using-fsharp-in-visual-studio/configuring-projects.md)
### [Targeting Older Versions of .NET](fsharp/using-fsharp-in-visual-studio/targeting-older-versions-of-net.md)

## [Using F# on Azure](fsharp/using-fsharp-on-azure/index.md)
### [Get started with Azure Blob storage using F#](fsharp/using-fsharp-on-azure/blob-storage.md)
### [Get started with Azure File storage using F#](fsharp/using-fsharp-on-azure/file-storage.md)
### [Get started with Azure Queue storage using F#](fsharp/using-fsharp-on-azure/queue-storage.md)
### [Get started with Azure Table storage using F#](fsharp/using-fsharp-on-azure/table-storage.md)
### [Using F# on Azure Service Fabric](fsharp/using-fsharp-on-azure/using-fsharp-on-azure-service-fabric.md)
### [Package Management for F# Azure Dependencies](fsharp/using-fsharp-on-azure/package-management.md)

## [F# Language Reference](fsharp/language-reference/index.md)
### [Keyword Reference](fsharp/language-reference/keyword-reference.md)
### [Symbol and Operator Reference](fsharp/language-reference/symbol-and-operator-reference/index.md)
#### [Arithmetic Operators](fsharp/language-reference/symbol-and-operator-reference/arithmetic-operators.md)
#### [Boolean Operators](fsharp/language-reference/symbol-and-operator-reference/boolean-operators.md)
#### [Bitwise Operators](fsharp/language-reference/symbol-and-operator-reference/bitwise-operators.md)
#### [Nullable Operators](fsharp/language-reference/symbol-and-operator-reference/nullable-operators.md)
### [Functions](fsharp/language-reference/functions/index.md)
#### [let Bindings](fsharp/language-reference/functions/let-bindings.md)
#### [do Bindings](fsharp/language-reference/functions/do-bindings.md)
#### [Lambda Expressions: the fun keyword](fsharp/language-reference/functions/lambda-expressions-the-fun-keyword.md)
#### [Recursive Functions: the rec keyword](fsharp/language-reference/functions/recursive-functions-the-rec-keyword.md)
#### [Entry Point](fsharp/language-reference/functions/entry-point.md)
#### [External Functions](fsharp/language-reference/functions/external-functions.md)
#### [Inline Functions](fsharp/language-reference/functions/inline-functions.md)
### [Values](fsharp/language-reference/values/index.md)
#### [Null Values](fsharp/language-reference/values/null-values.md)
### [Literals](fsharp/language-reference/literals.md)
### [F# Types](fsharp/language-reference/fsharp-types.md)
### [Type Inference](fsharp/language-reference/type-inference.md)
### [Primitive Types](fsharp/language-reference/primitive-types.md)
### [Unit Type](fsharp/language-reference/unit-type.md)
### [Strings](fsharp/language-reference/strings.md)
### [Tuples](fsharp/language-reference/tuples.md)
### [F# Collection Types](fsharp/language-reference/fsharp-collection-types.md)
### [Lists](fsharp/language-reference/lists.md)
### [Options](fsharp/language-reference/options.md)
### [Sequences](fsharp/language-reference/sequences.md)
### [Arrays](fsharp/language-reference/arrays.md)
### [Generics](fsharp/language-reference/generics/index.md)
#### [Automatic Generalization](fsharp/language-reference/generics/automatic-generalization.md)
#### [Constraints](fsharp/language-reference/generics/constraints.md)
#### [Statically Resolved Type Parameters](fsharp/language-reference/generics/statically-resolved-type-parameters.md)
### [Records](fsharp/language-reference/records.md)
### [Discriminated Unions](fsharp/language-reference/discriminated-unions.md)
### [Enumerations](fsharp/language-reference/enumerations.md)
### [Reference Cells](fsharp/language-reference/reference-cells.md)
### [Type Abbreviations](fsharp/language-reference/type-abbreviations.md)
### [Classes](fsharp/language-reference/classes.md)
### [Structures](fsharp/language-reference/structures.md)
### [Inheritance](fsharp/language-reference/inheritance.md)
### [Interfaces](fsharp/language-reference/interfaces.md)
### [Abstract Classes](fsharp/language-reference/abstract-classes.md)
### [Members](fsharp/language-reference/members/index.md)
#### [let Bindings in Classes](fsharp/language-reference/members/let-bindings-in-classes.md)
#### [do Bindings in Classes](fsharp/language-reference/members/do-bindings-in-classes.md)
#### [Properties](fsharp/language-reference/members/properties.md)
#### [Indexed Properties](fsharp/language-reference/members/indexed-properties.md)
#### [Methods](fsharp/language-reference/members/methods.md)
#### [Constructors](fsharp/language-reference/members/constructors.md)
#### [Events](fsharp/language-reference/members/events.md)
#### [Explicit Fields: The `val` Keyword](fsharp/language-reference/members/explicit-fields-the-val-keyword.md)
### [Type Extensions](fsharp/language-reference/type-extensions.md)
### [Parameters and Arguments](fsharp/language-reference/parameters-and-arguments.md)
### [Operator Overloading](fsharp/language-reference/operator-overloading.md)
### [Flexible Types](fsharp/language-reference/flexible-types.md)
### [Delegates](fsharp/language-reference/delegates.md)
### [Object Expressions](fsharp/language-reference/object-expressions.md)
### [Copy and Update Record Expressions](fsharp/language-reference/copy-and-update-record-expressions.md)
### [Casting and Conversions](fsharp/language-reference/casting-and-conversions.md)
### [Access Control](fsharp/language-reference/access-control.md)
### [Conditional Expressions: if...then...else](fsharp/language-reference/conditional-expressions-if-then-else.md)
### [Match Expressions](fsharp/language-reference/match-expressions.md)
### [Pattern Matching](fsharp/language-reference/pattern-matching.md)
### [Active Patterns](fsharp/language-reference/active-patterns.md)
### [Loops: for...to Expression](fsharp/language-reference/loops-for-to-expression.md)
### [Loops: for...in Expression](fsharp/language-reference/loops-for-in-expression.md)
### [Loops: while...do Expression](fsharp/language-reference/loops-while-do-expression.md)
### [Assertions](fsharp/language-reference/assertions.md)
### [Exception Handling](fsharp/language-reference/exception-handling/index.md)
#### [Exception Types](fsharp/language-reference/exception-handling/exception-types.md)
#### [The try...with Expression](fsharp/language-reference/exception-handling/the-try-with-expression.md)
#### [The try...finally Expression](fsharp/language-reference/exception-handling/the-try-finally-expression.md)
#### [The raise Function](fsharp/language-reference/exception-handling/the-raise-function.md)
#### [The failwith Function](fsharp/language-reference/exception-handling/the-failwith-function.md)
#### [The invalidArg Function](fsharp/language-reference/exception-handling/the-invalidArg-function.md)
### [Attributes](fsharp/language-reference/attributes.md)
### [Resource Management: the use Keyword](fsharp/language-reference/resource-management-the-use-keyword.md)
### [Namespaces](fsharp/language-reference/namespaces.md)
### [Modules](fsharp/language-reference/modules.md)
### [Import Declarations: The open Keyword](fsharp/language-reference/import-declarations-the-open-keyword.md)
### [Signatures](fsharp/language-reference/signatures.md)
### [Units of Measure](fsharp/language-reference/units-of-measure.md)
### [XML Documentation](fsharp/language-reference/xml-documentation.md)
### [Lazy Computations](fsharp/language-reference/lazy-computations.md)
### [Computation Expressions](fsharp/language-reference/computation-expressions.md)
### [Asynchronous Workflows](fsharp/language-reference/asynchronous-workflows.md)
### [Query Expressions](fsharp/language-reference/query-expressions.md)
### [Code Quotations](fsharp/language-reference/code-quotations.md)
### [Compiler Directives](fsharp/language-reference/compiler-directives.md)
### [Compiler Options](fsharp/language-reference/compiler-options.md)
### [Source Line, File, and Path Identifiers](fsharp/language-reference/source-line-file-path-identifiers.md)
### [Verbose Syntax](fsharp/language-reference/verbose-syntax.md)
### [Code Formatting Guidelines](fsharp/language-reference/code-formatting-guidelines.md)
<!-- End F# Content -->

<!-- VB Content -->
# [Visual Basic Guide](visual-basic/index.md)
## [Get Started](visual-basic/getting-started/index.md)
### [What's New for Visual Basic](visual-basic/getting-started/whats-new.md)
### [Visual Basic Breaking Changes in Visual Studio 2015](visual-basic/getting-started/breaking-changes-in-visual-studio-2015.md)
### [Additional Resources for Visual Basic Programmers](visual-basic/getting-started/additional-resources.md)

## [Developing Applications](visual-basic/developing-apps/index.md)

### [Using the Visual Basic Development Environment](visual-basic/developing-apps/using-ide/using-the-visual-basic-development-environment.md)
#### [Visual Basic Settings](visual-basic/developing-apps/using-ide/settings.md)
#### [Visual Basic IntelliSense Code Snippets](visual-basic/developing-apps/using-ide/intellisense-code-snippets.md)
#### [Refactoring](https://docs.microsoft.com/en-us/visualstudio/vb-ide/refactoring-vb)
#### [Code Generation](https://docs.microsoft.com/en-us/visualstudio/vb-ide/code-generation-vb)
#### [Help for Event Handlers in Visual Basic Code](visual-basic/developing-apps/using-ide/help-for-event-handlers.md)
#### [How to: Compile and Run a Project in Visual Basic](visual-basic/developing-apps/using-ide/how-to-compile-and-run-a-project.md)

### [Programming in Visual Basic](visual-basic/developing-apps/programming/index.md)
#### [Accessing Computer Resources](visual-basic/developing-apps/programming/computer-resources/computer-resources.md)
#### [Logging Information from the Application](visual-basic/developing-apps/programming/log-info/logging-information-from-the-application.md)
#### [Accessing User Data](visual-basic/developing-apps/programming/accessing-user-data.md)
#### [Accessing Application Forms](visual-basic/developing-apps/programming/accessing-application-forms.md)
#### [Accessing Application Web Services](visual-basic/developing-apps/programming/accessing-application-web-services.md)
##### [How to: Call a Web Service Asynchronously](visual-basic/developing-apps/programming/how-to-call-a-web-service-asynchronously.md)
#### [Accessing Application Settings](visual-basic/developing-apps/programming/app-settings/accessing-application-settings.md)
#### [Processing Drives, Directories, and Files](visual-basic/developing-apps/programming/drives-directories-files/processing.md)

### [Development with My](visual-basic/developing-apps/development-with-my/index.md)
#### [Performing Tasks with My.Application, My.Computer, and My.User](visual-basic/developing-apps/development-with-my/performing-tasks-with-my-application-my-computer-and-my-user.md)
#### [Default Object Instances Provided by My.Forms and My.WebServices](visual-basic/developing-apps/development-with-my/default-object-instances-provided-by-my-forms-and-my-webservices.md)
#### [Rapid Application Development with My.Resources and My.Settings](visual-basic/developing-apps/development-with-my/rapid-application-development-with-my-resources-and-my-settings.md)
#### [Overview of the Visual Basic Application Model](visual-basic/developing-apps/development-with-my/overview-of-the-visual-basic-application-model.md)
#### [How My Depends on Project Type](visual-basic/developing-apps/development-with-my/how-my-depends-on-project-type.md)

### [Accessing Data](visual-basic/developing-apps/accessing-data.md)
### [Debugging](visual-basic/developing-apps/debugging.md)
### [Creating and Using Components](visual-basic/developing-apps/creating-and-using-components.md)

### [Printing and Reporting](visual-basic/developing-apps/printing/printing-and-reporting.md)
#### [PrintForm Component](visual-basic/developing-apps/printing/printform-component.md)
#### [How to: Print a Scrollable Form](visual-basic/developing-apps/printing/how-to-print-a-scrollable-form.md)
#### [How to: Print Client and Non-Client Areas of a Form](visual-basic/developing-apps/printing/how-to-print-client-and-non-client-areas-of-a-form.md)
#### [How to: Print the Client Area of a Form](visual-basic/developing-apps/printing/how-to-print-the-client-area-of-a-form.md)
#### [How to: Print a Form by Using the PrintForm Component](visual-basic/developing-apps/printing/how-to-print-a-form-by-using-the-printform-component.md)
#### [Deploying Applications That Reference the PrintForm Component](visual-basic/developing-apps/printing/deploying-applications-that-reference-the-printform-component.md)
#### [Adding Printable Reports to Visual Studio Applications](visual-basic/developing-apps/printing/adding-printable-reports-to-visual-studio-applications.md)

### [Windows Forms Application Basics](visual-basic/developing-apps/windows-forms/windows-forms-application-basics.md)
### [Power Packs Controls](visual-basic/developing-apps/windows-forms/power-packs-controls.md)
### [DataRepeater Control](visual-basic/developing-apps/windows-forms/datarepeater-control-visual-studio.md)
#### [Introduction to the DataRepeater Control](visual-basic/developing-apps/windows-forms/introduction-to-the-datarepeater-control-visual-studio.md)
#### [Virtual Mode in the DataRepeater Control](visual-basic/developing-apps/windows-forms/virtual-mode-in-the-datarepeater-control-visual-studio.md)
#### [How to: Display Bound Data in a DataRepeater Control](visual-basic/developing-apps/windows-forms/how-to-display-bound-data-in-a-datarepeater-control-visual-studio.md)
#### [How to: Display Unbound Controls in a DataRepeater Control](visual-basic/developing-apps/windows-forms/how-to-display-unbound-controls-in-a-datarepeater-control-visual-studio.md)
#### [How to: Change the Layout of a DataRepeater Control](visual-basic/developing-apps/windows-forms/how-to-change-the-layout-of-a-datarepeater-control-visual-studio.md)
#### [How to: Change the Appearance of a DataRepeater Control](visual-basic/developing-apps/windows-forms/how-to-change-the-appearance-of-a-datarepeater-control-visual-studio.md)
#### [How to: Display Item Headers in a DataRepeater Control](visual-basic/developing-apps/windows-forms/how-to-display-item-headers-in-a-datarepeater-control-visual-studio.md)
#### [How to: Disable Adding and Deleting DataRepeater Items](visual-basic/developing-apps/windows-forms/how-to-disable-adding-and-deleting-datarepeater-items-visual-studio.md)
#### [How to: Search Data in a DataRepeater Control](visual-basic/developing-apps/windows-forms/how-to-search-data-in-a-datarepeater-control-visual-studio.md)
#### [How to: Create a Master-Detail Form by Using Two DataRepeater Controls](visual-basic/developing-apps/windows-forms/how-to-create-a-master-detail-form-by-using-two-datarepeater-controls.md)
#### [Walkthrough: Displaying Data in a DataRepeater Control](visual-basic/developing-apps/windows-forms/walkthrough-displaying-data-in-a-datarepeater-control-visual-studio.md)
#### [Troubleshooting the DataRepeater Control](visual-basic/developing-apps/windows-forms/troubleshooting-the-datarepeater-control-visual-studio.md)
### [Line and Shape Controls](visual-basic/developing-apps/windows-forms/line-and-shape-controls-visual-studio.md)
#### [Introduction to the Line and Shape Controls](visual-basic/developing-apps/windows-forms/introduction-to-the-line-and-shape-controls-visual-studio.md)
#### [How to: Draw Lines with the LineShape Control](visual-basic/developing-apps/windows-forms/how-to-draw-lines-with-the-lineshape-control-visual-studio.md)
#### [How to: Draw Shapes with the OvalShape and RectangleShape Controls](visual-basic/developing-apps/windows-forms/how-to-draw-shapes-with-the-ovalshape-and-rectangleshape-controls.md)
#### [How to: Enable Tabbing Between Shapes](visual-basic/developing-apps/windows-forms/how-to-enable-tabbing-between-shapes-visual-studio.md)
#### [Deploying Applications That Reference Power Packs Controls](visual-basic/developing-apps/windows-forms/deploying-applications-that-reference-power-packs-controls-visual-studio.md)

### [Customizing Projects and Extending My with Visual Basic](visual-basic/developing-apps/customizing-extending-my/customizing-projects-and-extending-my.md)
#### [Extending the My Namespace](visual-basic/developing-apps/customizing-extending-my/extending-the-my-namespace.md)
#### [Packaging and Deploying Custom My Extensions](visual-basic/developing-apps/customizing-extending-my/packaging-and-deploying-custom-my-extensions.md)
#### [Extending the Visual Basic Application Model](visual-basic/developing-apps/customizing-extending-my/extending-the-visual-basic-application-model.md)
#### [Customizing Which Objects are Available in My](visual-basic/developing-apps/customizing-extending-my/customizing-which-objects-are-available-in-my.md)

## [Programming Concepts](visual-basic/programming-guide/concepts/index.md)
### [Assemblies and the Global Assembly Cache](visual-basic/programming-guide/concepts/assemblies-gac/index.md)
### [Asynchronous Programming with Async and Await](visual-basic/programming-guide/concepts/async/index.md)
### [Attributes](visual-basic/programming-guide/concepts/attributes/index.md)
### [Expression Trees](visual-basic/programming-guide/concepts/expression-trees/index.md)
### [Iterators](visual-basic/programming-guide/concepts/iterators.md)
### [Language-Integrated Query (LINQ)](visual-basic/programming-guide/concepts/linq/index.md)
### [Object-Oriented Programming](visual-basic/programming-guide/concepts/object-oriented-programming.md)
### [Reflection](visual-basic/programming-guide/concepts/reflection.md)
### [Serialization](visual-basic/programming-guide/concepts/serialization/index.md)
### [Threading](visual-basic/programming-guide/concepts/threading/index.md)

## [Program Structure and Code Conventions](visual-basic/programming-guide/program-structure/program-structure-and-code-conventions.md)
### [Structure of a Program](visual-basic/programming-guide/program-structure/structure-of-a-visual-basic-program.md)
### [Main Procedure](visual-basic/programming-guide/program-structure/main-procedure.md)
### [References and the Imports Statement](visual-basic/programming-guide/program-structure/references-and-the-imports-statement.md)
### [Namespaces](visual-basic/programming-guide/program-structure/namespaces.md)
### [Naming Conventions](visual-basic/programming-guide/program-structure/naming-conventions.md)
### [Coding Conventions](visual-basic/programming-guide/program-structure/coding-conventions.md)
### [Conditional Compilation](visual-basic/programming-guide/program-structure/conditional-compilation.md)
### [How to: Break and Combine Statements in Code](visual-basic/programming-guide/program-structure/how-to-break-and-combine-statements-in-code.md)
### [How to: Collapse and Hide Sections of Code](visual-basic/programming-guide/program-structure/how-to-collapse-and-hide-sections-of-code.md)
### [How to: Label Statements](visual-basic/programming-guide/program-structure/how-to-label-statements.md)
### [Special Characters in Code](visual-basic/programming-guide/program-structure/special-characters-in-code.md)
### [Comments in Code](visual-basic/programming-guide/program-structure/comments-in-code.md)
### [Keywords as Element Names in Code](visual-basic/programming-guide/program-structure/keywords-as-element-names-in-code.md)
### [Me, My, MyBase, and MyClass](visual-basic/programming-guide/program-structure/me-my-mybase-and-myclass.md)
### [Limitations](visual-basic/programming-guide/program-structure/limitations.md)

## [Language Features](visual-basic/programming-guide/language-features/index.md)
### [Arrays](visual-basic/programming-guide/language-features/arrays/index.md)
### [Collection Initializers](visual-basic/programming-guide/language-features/collection-initializers/index.md)
### [Constants and Enumerations](visual-basic/programming-guide/language-features/constants-enums/index.md)
### [Control Flow](visual-basic/programming-guide/language-features/control-flow/index.md)
### [Data Types](visual-basic/programming-guide/language-features/data-types/index.md)
### [Declared Elements](visual-basic/programming-guide/language-features/declared-elements/index.md)
### [Delegates](visual-basic/programming-guide/language-features/delegates/index.md)
### [Early and Late Binding](visual-basic/programming-guide/language-features/early-late-binding/index.md)
### [Error Types](visual-basic/programming-guide/language-features/error-types.md)
### [Events](visual-basic/programming-guide/language-features/events/index.md)
### [Interfaces](visual-basic/programming-guide/language-features/interfaces/index.md)
#### [Walkthrough: Creating and Implementing Interfaces](visual-basic/programming-guide/language-features/interfaces/walkthrough-creating-and-implementing-interfaces.md)
### [LINQ](visual-basic/programming-guide/language-features/linq/index.md)
### [Objects and Classes](visual-basic/programming-guide/language-features/objects-and-classes/index.md)
### [Operators and Expressions](visual-basic/programming-guide/language-features/operators-and-expressions/index.md)
### [Procedures](visual-basic/programming-guide/language-features/procedures/index.md)
### [Statements](visual-basic/programming-guide/language-features/statements.md)
### [Strings](visual-basic/programming-guide/language-features/strings/index.md)
### [Variables](visual-basic/programming-guide/language-features/variables/index.md)
### [XML](visual-basic/programming-guide/language-features/xml/index.md)

## [COM Interop](visual-basic/programming-guide/com-interop/index.md)
### [Introduction to COM Interop](visual-basic/programming-guide/com-interop/introduction-to-com-interop.md)
### [How to: Reference COM Objects](visual-basic/programming-guide/com-interop/how-to-reference-com-objects.md)
### [How to: Work with ActiveX Controls](visual-basic/programming-guide/com-interop/how-to-work-with-activex-controls.md)
### [Walkthrough: Calling Windows APIs](visual-basic/programming-guide/com-interop/walkthrough-calling-windows-apis.md)
### [How to: Call Windows APIs](visual-basic/programming-guide/com-interop/how-to-call-windows-apis.md)
### [How to: Call a Windows Function that Takes Unsigned Types](visual-basic/programming-guide/com-interop/how-to-call-a-windows-function-that-takes-unsigned-types.md)
### [Walkthrough: Creating COM Objects](visual-basic/programming-guide/com-interop/walkthrough-creating-com-objects.md)
### [Troubleshooting Interoperability](visual-basic/programming-guide/com-interop/troubleshooting-interoperability.md)
### [COM Interoperability in .NET Framework Applications](visual-basic/programming-guide/com-interop/com-interoperability-in-net-framework-applications.md)
### [Walkthrough: Implementing Inheritance with COM Objects](visual-basic/programming-guide/com-interop/walkthrough-implementing-inheritance-with-com-objects.md)

## [Language Reference](visual-basic/language-reference/index.md)
### [Typographic and Code Conventions](visual-basic/language-reference/typographic-and-code-conventions.md)
### [Visual Basic Runtime Library Members](visual-basic/language-reference/runtime-library-members.md)
### [Keywords](visual-basic/language-reference/keywords/index.md)
#### [Arrays Summary](visual-basic/language-reference/keywords/arrays-summary.md)
#### [Collection Object Summary](visual-basic/language-reference/keywords/collection-object-summary.md)
#### [Control Flow Summary](visual-basic/language-reference/keywords/control-flow-summary.md)
#### [Conversion Summary](visual-basic/language-reference/keywords/conversion-summary.md)
#### [Data Types Summary](visual-basic/language-reference/keywords/data-types-summary.md)
#### [Dates and Times Summary](visual-basic/language-reference/keywords/dates-and-times-summary.md)
#### [Declarations and Constants Summary](visual-basic/language-reference/keywords/declarations-and-constants-summary.md)
#### [Directories and Files Summary](visual-basic/language-reference/keywords/directories-and-files-summary.md)
#### [Errors Summary](visual-basic/language-reference/keywords/errors-summary.md)
#### [Financial Summary](visual-basic/language-reference/keywords/financial-summary.md)
#### [Information and Interaction Summary](visual-basic/language-reference/keywords/information-and-interaction-summary.md)
#### [Input and Output Summary](visual-basic/language-reference/keywords/input-and-output-summary.md)
#### [Math Summary](visual-basic/language-reference/keywords/math-summary.md)
##### [Derived Math Functions](visual-basic/language-reference/keywords/derived-math-functions.md)
#### [My Reference](visual-basic/language-reference/keywords/my-reference.md)
#### [Operators Summary](visual-basic/language-reference/keywords/operators-summary.md)
#### [Registry Summary](visual-basic/language-reference/keywords/registry-summary.md)
#### [String Manipulation Summary](visual-basic/language-reference/keywords/string-manipulation-summary.md)
### [Attributes](visual-basic/language-reference/attributes.md)
### [Constants and Enumerations](visual-basic/language-reference/constants-and-enumerations.md)
### [Data Type Summary](visual-basic/language-reference/data-types/data-type-summary.md)
#### [Boolean Data Type](visual-basic/language-reference/data-types/boolean-data-type.md)
#### [Byte Data Type](visual-basic/language-reference/data-types/byte-data-type.md)
#### [Char Data Type](visual-basic/language-reference/data-types/char-data-type.md)
#### [Date Data Type](visual-basic/language-reference/data-types/date-data-type.md)
#### [Decimal Data Type](visual-basic/language-reference/data-types/decimal-data-type.md)
#### [Double Data Type](visual-basic/language-reference/data-types/double-data-type.md)
#### [Integer Data Type](visual-basic/language-reference/data-types/integer-data-type.md)
#### [Long Data Type](visual-basic/language-reference/data-types/long-data-type.md)
#### [Object Data Type](visual-basic/language-reference/data-types/object-data-type.md)
#### [SByte Data Type](visual-basic/language-reference/data-types/sbyte-data-type.md)
#### [Short Data Type](visual-basic/language-reference/data-types/short-data-type.md)
#### [Single Data Type](visual-basic/language-reference/data-types/single-data-type.md)
#### [String Data Type](visual-basic/language-reference/data-types/string-data-type.md)
#### [UInteger Data Type](visual-basic/language-reference/data-types/uinteger-data-type.md)
#### [ULong Data Type](visual-basic/language-reference/data-types/ulong-data-type.md)
#### [User-Defined Data Type](visual-basic/language-reference/data-types/user-defined-data-type.md)
#### [UShort Data Type](visual-basic/language-reference/data-types/ushort-data-type.md)
### [Directives](visual-basic/language-reference/directives/directives.md)
#### [#Const Directive](visual-basic/language-reference/directives/const-directive.md)
#### [#ExternalSource Directive](visual-basic/language-reference/directives/externalsource-directive.md)
#### [#If...Then...#Else Directives](visual-basic/language-reference/directives/if-then-else-directives.md)
#### [#Region Directive](visual-basic/language-reference/directives/region-directive.md)

### [Functions](visual-basic/language-reference/functions/index.md)
#### [Conversion Functions](visual-basic/language-reference/functions/conversion-functions.md)
#### [Math Functions](visual-basic/language-reference/functions/math-functions.md)
#### [String Functions](visual-basic/language-reference/functions/string-functions.md)
#### [Type Conversion Functions](visual-basic/language-reference/functions/type-conversion-functions.md)
##### [Return Values for the CStr Function](visual-basic/language-reference/functions/return-values-for-the-cstr-function.md)
#### [CType Function](visual-basic/language-reference/functions/ctype-function.md)
### [Modifiers](visual-basic/language-reference/modifiers/index.md)
#### [Ansi](visual-basic/language-reference/modifiers/ansi.md)
#### [Assembly](visual-basic/language-reference/modifiers/assembly.md)
#### [Async](visual-basic/language-reference/modifiers/async.md)
#### [Auto](visual-basic/language-reference/modifiers/auto.md)
#### [ByRef](visual-basic/language-reference/modifiers/byref.md)
#### [ByVal](visual-basic/language-reference/modifiers/byval.md)
#### [Default](visual-basic/language-reference/modifiers/default.md)
#### [Friend](visual-basic/language-reference/modifiers/friend.md)
#### [In (Generic Modifier)](visual-basic/language-reference/modifiers/in-generic-modifier.md)
#### [Iterator](visual-basic/language-reference/modifiers/iterator.md)
#### [Key](visual-basic/language-reference/modifiers/key.md)
#### [Module <keyword>](visual-basic/language-reference/modifiers/module-keyword.md)
#### [MustInherit](visual-basic/language-reference/modifiers/mustinherit.md)
#### [MustOverride](visual-basic/language-reference/modifiers/mustoverride.md)
#### [Narrowing](visual-basic/language-reference/modifiers/narrowing.md)
#### [NotInheritable](visual-basic/language-reference/modifiers/notinheritable.md)
#### [NotOverridable](visual-basic/language-reference/modifiers/notoverridable.md)
#### [Optional](visual-basic/language-reference/modifiers/optional.md)
#### [Out (Generic Modifier)](visual-basic/language-reference/modifiers/out-generic-modifier.md)
#### [Overloads](visual-basic/language-reference/modifiers/overloads.md)
#### [Overridable](visual-basic/language-reference/modifiers/overridable.md)
#### [Overrides](visual-basic/language-reference/modifiers/overrides.md)
#### [ParamArray](visual-basic/language-reference/modifiers/paramarray.md)
#### [Partial](visual-basic/language-reference/modifiers/partial.md)
#### [Private](visual-basic/language-reference/modifiers/private.md)
#### [Protected](visual-basic/language-reference/modifiers/protected.md)
#### [Public](visual-basic/language-reference/modifiers/public.md)
#### [ReadOnly](visual-basic/language-reference/modifiers/readonly.md)
#### [Shadows](visual-basic/language-reference/modifiers/shadows.md)
#### [Shared](visual-basic/language-reference/modifiers/shared.md)
#### [Static](visual-basic/language-reference/modifiers/static.md)
#### [Unicode](visual-basic/language-reference/modifiers/unicode.md)
#### [Widening](visual-basic/language-reference/modifiers/widening.md)
#### [WithEvents](visual-basic/language-reference/modifiers/withevents.md)
#### [WriteOnly](visual-basic/language-reference/modifiers/writeonly.md)
### [Modules](visual-basic/language-reference/modules.md)
### [Nothing](visual-basic/language-reference/nothing.md)
### [Objects](visual-basic/language-reference/objects/index.md)
#### [My.Application Object](visual-basic/language-reference/objects/my-application-object.md)
##### [My.Application.Info Object](visual-basic/language-reference/objects/my-application-info-object.md)
##### [My.Application.Log Object](visual-basic/language-reference/objects/my-application-log-object.md)
#### [My.Computer Object](visual-basic/language-reference/objects/my-computer-object.md)
##### [My.Computer.Audio Object](visual-basic/language-reference/objects/my-computer-audio-object.md)
##### [My.Computer.Clipboard Object](visual-basic/language-reference/objects/my-computer-clipboard-object.md)
##### [My.Computer.Clock Object](visual-basic/language-reference/objects/my-computer-clock-object.md)
##### [My.Computer.FileSystem Object](visual-basic/language-reference/objects/my-computer-filesystem-object.md)
###### [My.Computer.FileSystem.SpecialDirectories Object](visual-basic/language-reference/objects/my-computer-filesystem-specialdirectories-object.md)
##### [My.Computer.Info Object](visual-basic/language-reference/objects/my-computer-info-object.md)
##### [My.Computer.Keyboard Object](visual-basic/language-reference/objects/my-computer-keyboard-object.md)
##### [My.Computer.Mouse Object](visual-basic/language-reference/objects/my-computer-mouse-object.md)
##### [My.Computer.Network Object](visual-basic/language-reference/objects/my-computer-network-object.md)
##### [My.Computer.Ports Object](visual-basic/language-reference/objects/my-computer-ports-object.md)
##### [My.Computer.Registry Object](visual-basic/language-reference/objects/my-computer-registry-object.md)
#### [My.Forms Object](visual-basic/language-reference/objects/my-forms-object.md)
#### [My.Log Object](visual-basic/language-reference/objects/my-log-object.md)
#### [My.Request Object](visual-basic/language-reference/objects/my-request-object.md)
#### [My.Response Object](visual-basic/language-reference/objects/my-response-object.md)
#### [My.Resources Object](visual-basic/language-reference/objects/my-resources-object.md)
#### [My.Settings Object](visual-basic/language-reference/objects/my-settings-object.md)
#### [My.User Object](visual-basic/language-reference/objects/my-user-object.md)
#### [My.WebServices Object](visual-basic/language-reference/objects/my-webservices-object.md)
#### [TextFieldParser Object](visual-basic/language-reference/objects/textfieldparser-object.md)

### [Operators](visual-basic/language-reference/operators/index.md)
#### [Operator Precedence](visual-basic/language-reference/operators/operator-precedence.md)
#### [Operators Listed by Functionality](visual-basic/language-reference/operators/operators-listed-by-functionality.md)
##### [& Operator](visual-basic/language-reference/operators/concatenation-operator.md)
##### [&= Operator](visual-basic/language-reference/operators/and-assignment-operator.md)
##### [* Operator](visual-basic/language-reference/operators/multiplication-operator.md)
##### [*= Operator](visual-basic/language-reference/operators/multiplication-assignment-operator.md)
##### [+ Operator](visual-basic/language-reference/operators/addition-operator.md)
##### [+= Operator](visual-basic/language-reference/operators/addition-assignment-operator.md)
##### [= Operator](visual-basic/language-reference/operators/assignment-operator.md)
##### [- Operator](visual-basic/language-reference/operators/subtraction-operator.md)
##### [-= Operator](visual-basic/language-reference/operators/subtraction-assignment-operator.md)
##### [<< Operator](visual-basic/language-reference/operators/left-shift-operator.md)
##### [<<= Operator](visual-basic/language-reference/operators/left-shift-assignment-operator.md)
##### [>> Operator](visual-basic/language-reference/operators/right-shift-operator.md)
##### [>>= Operator](visual-basic/language-reference/operators/right-shift-assignment-operator.md)
##### [/ Operator](visual-basic/language-reference/operators/floating-point-division-operator.md)
##### [/= Operator](visual-basic/language-reference/operators/floating-point-division-assignment-operator.md)
##### [\ Operator](visual-basic/language-reference/operators/integer-division-operator.md)
##### [\= Operator](visual-basic/language-reference/operators/integer-division-assignment-operator.md)
##### [^ Operator](visual-basic/language-reference/operators/exponentiation-operator.md)
##### [^= Operator](visual-basic/language-reference/operators/exponentiation-assignment-operator.md)
##### [AddressOf Operator](visual-basic/language-reference/operators/addressof-operator.md)
##### [And Operator](visual-basic/language-reference/operators/and-operator.md)
##### [AndAlso Operator](visual-basic/language-reference/operators/andalso-operator.md)
##### [Await Operator](visual-basic/language-reference/operators/await-operator.md)
##### [Function Expression](visual-basic/language-reference/operators/function-expression.md)
##### [GetType Operator](visual-basic/language-reference/operators/gettype-operator.md)
##### [GetXmlNamespace Operator](visual-basic/language-reference/operators/getxmlnamespace-operator.md)
##### [If Operator](visual-basic/language-reference/operators/if-operator.md)
##### [Is Operator](visual-basic/language-reference/operators/is-operator.md)
##### [IsFalse Operator](visual-basic/language-reference/operators/isfalse-operator.md)
##### [IsNot Operator](visual-basic/language-reference/operators/isnot-operator.md)
##### [IsTrue Operator](visual-basic/language-reference/operators/istrue-operator.md)
##### [Like Operator](visual-basic/language-reference/operators/like-operator.md)
##### [Mod Operator](visual-basic/language-reference/operators/mod-operator.md)
##### [Not Operator](visual-basic/language-reference/operators/not-operator.md)
##### [Or Operator](visual-basic/language-reference/operators/or-operator.md)
##### [OrElse Operator](visual-basic/language-reference/operators/orelse-operator.md)
##### [Sub Expression](visual-basic/language-reference/operators/sub-expression.md)
##### [TypeOf Operator](visual-basic/language-reference/operators/typeof-operator.md)
##### [Xor Operator](visual-basic/language-reference/operators/xor-operator.md)
#### [Data Types of Operator Results](visual-basic/language-reference/operators/data-types-of-operator-results.md)
#### [DirectCast Operator](visual-basic/language-reference/operators/directcast-operator.md)
#### [TryCast Operator](visual-basic/language-reference/operators/trycast-operator.md)
#### [New Operator](visual-basic/language-reference/operators/new-operator.md)
#### [Arithmetic Operators](visual-basic/language-reference/operators/arithmetic-operators.md)
#### [Assignment Operators](visual-basic/language-reference/operators/assignment-operators.md)
#### [Bit Shift Operators](visual-basic/language-reference/operators/bit-shift-operators.md)
#### [Comparison Operators](visual-basic/language-reference/operators/comparison-operators.md)
#### [Concatenation Operators](visual-basic/language-reference/operators/concatenation-operators.md)
#### [Logical-Bitwise Operators](visual-basic/language-reference/operators/logical-bitwise-operators.md)
#### [Miscellaneous Operators](visual-basic/language-reference/operators/miscellaneous-operators.md)
### [Properties](visual-basic/language-reference/properties.md)
### [Queries](visual-basic/language-reference/queries/queries.md)
#### [Aggregate Clause](visual-basic/language-reference/queries/aggregate-clause.md)
#### [Distinct Clause](visual-basic/language-reference/queries/distinct-clause.md)
#### [Equals Clause](visual-basic/language-reference/queries/equals-clause.md)
#### [From Clause](visual-basic/language-reference/queries/from-clause.md)
#### [Group By Clause](visual-basic/language-reference/queries/group-by-clause.md)
#### [Group Join Clause](visual-basic/language-reference/queries/group-join-clause.md)
#### [Join Clause](visual-basic/language-reference/queries/join-clause.md)
#### [Let Clause](visual-basic/language-reference/queries/let-clause.md)
#### [Order By Clause](visual-basic/language-reference/queries/order-by-clause.md)
#### [Select Clause](visual-basic/language-reference/queries/select-clause.md)
#### [Skip Clause](visual-basic/language-reference/queries/skip-clause.md)
#### [Skip While Clause](visual-basic/language-reference/queries/skip-while-clause.md)
#### [Take Clause](visual-basic/language-reference/queries/take-clause.md)
#### [Take While Clause](visual-basic/language-reference/queries/take-while-clause.md)
#### [Where Clause](visual-basic/language-reference/queries/where-clause.md)
### [Statements](visual-basic/language-reference/statements/index.md)
#### [A-E Statements](visual-basic/language-reference/statements/a-e-statements.md)
##### [AddHandler Statement](visual-basic/language-reference/statements/addhandler-statement.md)
##### [Call Statement](visual-basic/language-reference/statements/call-statement.md)
##### [Class Statement](visual-basic/language-reference/statements/class-statement.md)
##### [Const Statement](visual-basic/language-reference/statements/const-statement.md)
##### [Continue Statement](visual-basic/language-reference/statements/continue-statement.md)
##### [Declare Statement](visual-basic/language-reference/statements/declare-statement.md)
##### [Delegate Statement](visual-basic/language-reference/statements/delegate-statement.md)
##### [Dim Statement](visual-basic/language-reference/statements/dim-statement.md)
##### [Do...Loop Statement](visual-basic/language-reference/statements/do-loop-statement.md)
##### [Else Statement](visual-basic/language-reference/statements/else-statement.md)
##### [End Statement](visual-basic/language-reference/statements/end-statement.md)
##### [End <keyword> Statement](visual-basic/language-reference/statements/end-keyword-statement.md)
##### [Enum Statement](visual-basic/language-reference/statements/enum-statement.md)
##### [Erase Statement](visual-basic/language-reference/statements/erase-statement.md)
##### [Error Statement](visual-basic/language-reference/statements/error-statement.md)
##### [Event Statement](visual-basic/language-reference/statements/event-statement.md)
##### [Exit Statement](visual-basic/language-reference/statements/exit-statement.md)
#### [F-P Statements](visual-basic/language-reference/statements/f-p-statements.md)
##### [For Each...Next Statement](visual-basic/language-reference/statements/for-each-next-statement.md)
##### [For...Next Statement](visual-basic/language-reference/statements/for-next-statement.md)
##### [Function Statement](visual-basic/language-reference/statements/function-statement.md)
##### [Get Statement](visual-basic/language-reference/statements/get-statement.md)
##### [GoTo Statement](visual-basic/language-reference/statements/goto-statement.md)
##### [If...Then...Else Statement](visual-basic/language-reference/statements/if-then-else-statement.md)
##### [Implements Statement](visual-basic/language-reference/statements/implements-statement.md)
##### [Imports Statement (.NET Namespace and Type)](visual-basic/language-reference/statements/imports-statement-net-namespace-and-type.md)
##### [Imports Statement (XML Namespace)](visual-basic/language-reference/statements/imports-statement-xml-namespace.md)
##### [Inherits Statement](visual-basic/language-reference/statements/inherits-statement.md)
##### [Interface Statement](visual-basic/language-reference/statements/interface-statement.md)
##### [Mid Statement](visual-basic/language-reference/statements/mid-statement.md)
##### [Module Statement](visual-basic/language-reference/statements/module-statement.md)
##### [Namespace Statement](visual-basic/language-reference/statements/namespace-statement.md)
##### [On Error Statement](visual-basic/language-reference/statements/on-error-statement.md)
##### [Operator Statement](visual-basic/language-reference/statements/operator-statement.md)
##### [Option <keyword> Statement](visual-basic/language-reference/statements/option-keyword-statement.md)
##### [Option Compare Statement](visual-basic/language-reference/statements/option-compare-statement.md)
##### [Option Explicit Statement](visual-basic/language-reference/statements/option-explicit-statement.md)
##### [Option Infer Statement](visual-basic/language-reference/statements/option-infer-statement.md)
##### [Option Strict Statement](visual-basic/language-reference/statements/option-strict-statement.md)
##### [Property Statement](visual-basic/language-reference/statements/property-statement.md)
#### [Q-Z Statements](visual-basic/language-reference/statements/q-z-statements.md)
##### [RaiseEvent Statement](visual-basic/language-reference/statements/raiseevent-statement.md)
##### [ReDim Statement](visual-basic/language-reference/statements/redim-statement.md)
##### [REM Statement](visual-basic/language-reference/statements/rem-statement.md)
##### [RemoveHandler Statement](visual-basic/language-reference/statements/removehandler-statement.md)
##### [Resume Statement](visual-basic/language-reference/statements/resume-statement.md)
##### [Return Statement](visual-basic/language-reference/statements/return-statement.md)
##### [Select...Case Statement](visual-basic/language-reference/statements/select-case-statement.md)
##### [Set Statement](visual-basic/language-reference/statements/set-statement.md)
##### [Stop Statement](visual-basic/language-reference/statements/stop-statement.md)
##### [Structure Statement](visual-basic/language-reference/statements/structure-statement.md)
##### [Sub Statement](visual-basic/language-reference/statements/sub-statement.md)
##### [SyncLock Statement](visual-basic/language-reference/statements/synclock-statement.md)
##### [Then Statement](visual-basic/language-reference/statements/then-statement.md)
##### [Throw Statement](visual-basic/language-reference/statements/throw-statement.md)
##### [Try...Catch...Finally Statement](visual-basic/language-reference/statements/try-catch-finally-statement.md)
##### [Using Statement](visual-basic/language-reference/statements/using-statement.md)
##### [While...End While Statement](visual-basic/language-reference/statements/while-end-while-statement.md)
##### [With...End With Statement](visual-basic/language-reference/statements/with-end-with-statement.md)
##### [Yield Statement](visual-basic/language-reference/statements/yield-statement.md)
#### [Clauses](visual-basic/language-reference/statements/clauses.md)
##### [Alias Clause](visual-basic/language-reference/statements/alias-clause.md)
##### [As Clause](visual-basic/language-reference/statements/as-clause.md)
##### [Handles Clause](visual-basic/language-reference/statements/handles-clause.md)
##### [Implements Clause](visual-basic/language-reference/statements/implements-clause.md)
##### [In Clause](visual-basic/language-reference/statements/in-clause.md)
##### [Into Clause](visual-basic/language-reference/statements/into-clause.md)
##### [Of Clause](visual-basic/language-reference/statements/of-clause.md)
#### [Declaration Contexts and Default Access Levels](visual-basic/language-reference/statements/declaration-contexts-and-default-access-levels.md)
#### [Attribute List](visual-basic/language-reference/statements/attribute-list.md)
#### [Parameter List](visual-basic/language-reference/statements/parameter-list.md)
#### [Type List](visual-basic/language-reference/statements/type-list.md)
### [XML Comment Tags](visual-basic/language-reference/xmldoc/recommended-xml-tags-for-documentation-comments.md)
#### [<c>](visual-basic/language-reference/xmldoc/c.md)
#### [<code>](visual-basic/language-reference/xmldoc/code.md)
#### [<example>](visual-basic/language-reference/xmldoc/example.md)
#### [<exception>](visual-basic/language-reference/xmldoc/exception.md)
#### [<include>](visual-basic/language-reference/xmldoc/include.md)
#### [<list>](visual-basic/language-reference/xmldoc/list.md)
#### [<para>](visual-basic/language-reference/xmldoc/para.md)
#### [<param>](visual-basic/language-reference/xmldoc/param.md)
#### [<paramref>](visual-basic/language-reference/xmldoc/paramref.md)
#### [<permission>](visual-basic/language-reference/xmldoc/permission.md)
#### [<remarks>](visual-basic/language-reference/xmldoc/remarks.md)
#### [<returns>](visual-basic/language-reference/xmldoc/returns.md)
#### [<see>](visual-basic/language-reference/xmldoc/see.md)
#### [<seealso>](visual-basic/language-reference/xmldoc/seealso.md)
#### [<summary>](visual-basic/language-reference/xmldoc/summary.md)
#### [<typeparam>](visual-basic/language-reference/xmldoc/typeparam.md)
#### [<value>](visual-basic/language-reference/xmldoc/value.md)
### [XML Axis Properties](visual-basic/language-reference/xml-axis/xml-axis-properties.md)
#### [XML Attribute Axis Property](visual-basic/language-reference/xml-axis/xml-attribute-axis-property.md)
#### [XML Child Axis Property](visual-basic/language-reference/xml-axis/xml-child-axis-property.md)
#### [XML Descendant Axis Property](visual-basic/language-reference/xml-axis/xml-descendant-axis-property.md)
#### [Extension Indexer Property](visual-basic/language-reference/xml-axis/extension-indexer-property.md)
#### [XML Value Property](visual-basic/language-reference/xml-axis/xml-value-property.md)
### [XML Literals](visual-basic/language-reference/xml-literals/index.md)
#### [XML Element Literal](visual-basic/language-reference/xml-literals/xml-element-literal.md)
#### [XML Document Literal](visual-basic/language-reference/xml-literals/xml-document-literal.md)
#### [XML CDATA Literal](visual-basic/language-reference/xml-literals/xml-cdata-literal.md)
#### [XML Comment Literal](visual-basic/language-reference/xml-literals/xml-comment-literal.md)
#### [XML Processing Instruction Literal](visual-basic/language-reference/xml-literals/xml-processing-instruction-literal.md)

### [Error Messages](visual-basic/language-reference/error-messages/index.md)
#### ['#ElseIf' must be preceded by a matching '#If' or '#ElseIf'](visual-basic/language-reference/error-messages/elseif-must-be-preceded-by-a-matching-if-or-elseif.md)
#### ['#Region' and '#End Region' statements are not valid within method bodies-multiline lambdas](visual-basic/language-reference/error-messages/region-and-end-region-are-not-valid-within-method-bodies-multiline-lambdas.md)
#### ['<attribute>' cannot be applied because the format of the GUID '<number>' is not correct](visual-basic/language-reference/error-messages/attribute-cannot-be-applied-because-the-format-of-the-guid-is-not-correct.md)
#### ['<classname>' is not CLS-compliant because the interface '<interfacename>' it implements is not CLS-compliant](visual-basic/language-reference/error-messages/classname-is-not-cls-compliant-because-the-interface-is-not-cls-compliant.md)
#### ['<elementname>' is obsolete (Visual Basic Warning)](visual-basic/language-reference/error-messages/elementname-is-obsolete-visual-basic-warning.md)
#### ['<eventname>' is an event, and cannot be called directly](visual-basic/language-reference/error-messages/eventname-is-an-event-and-cannot-be-called-directly.md)
#### ['<expression>' cannot be used as a type constraint](visual-basic/language-reference/error-messages/expression-cannot-be-used-as-a-type-constraint.md)
#### ['<functionname>' is not declared (Smart Device-Visual Basic Compiler Error)](visual-basic/language-reference/error-messages/functionname-is-not-declared-smart-device-visual-basic-compiler-error.md)
#### ['<interfacename>.<membername>' is already implemented by the base class '<baseclassname>'. Re-implementation of <type> assumed](visual-basic/language-reference/error-messages/interfacename-membername-is-already-implemented-by-the-base-class.md)
#### ['<keyword>' is valid only within an instance method](visual-basic/language-reference/error-messages/keyword-is-valid-only-within-an-instance-method.md)
#### ['<membername>' cannot expose type '<typename>' outside the project through <containertype> '<containertypename>'](visual-basic/language-reference/error-messages/membername-cannot-expose-type-typename-outside-the-project.md)
#### ['<membername>' is ambiguous across the inherited interfaces '<interfacename1>' and '<interfacename2>'](visual-basic/language-reference/error-messages/membername-is-ambiguous-across-the-inherited-interfaces.md)
#### [<message> This error could also be due to mixing a file reference with a project reference to assembly '<assemblyname>'](visual-basic/language-reference/error-messages/message-this-error-could-also-be-due-to-mixing-a-file-reference.md)
#### ['<methodname>' has multiple definitions with identical signatures](visual-basic/language-reference/error-messages/methodname-has-multiple-definitions-with-identical-signatures.md)
#### ['<name>' is ambiguous in the namespace '<namespacename>'](visual-basic/language-reference/error-messages/name-is-ambiguous-in-the-namespace-namespacename.md)
#### ['<name1>' is ambiguous, imported from the namespaces or types '<name2>'](visual-basic/language-reference/error-messages/name1-is-ambiguous-imported-from-the-namespaces-or-types-name2.md)
#### [<proceduresignature1> is not CLS-compliant because it overloads <proceduresignature2> which differs from it only by array of array parameter types or by the rank of the array parameter types](visual-basic/language-reference/error-messages/proceduresignature1-not-cls-compliant-because-it-overloads-proceduresignature2.md)
#### [<type1>'<typename>' must implement '<membername>' for interface '<interfacename>'](visual-basic/language-reference/error-messages/type1-must-implement-membername-for-interface.md)
#### [<type1>'<typename>' must implement '<methodname>' for interface '<interfacename>'](visual-basic/language-reference/error-messages/type1-typename-must-implement-methodname-for-interface-interfacename.md)
#### ['<typename>' cannot inherit from <type> '<basetypename>' because it expands the access of the base <type> outside the assembly](visual-basic/language-reference/error-messages/typename-cannot-inherit-from-type-basetypename.md)
#### ['<typename>' is a delegate type](visual-basic/language-reference/error-messages/typename-is-a-delegate-type.md)
#### ['<typename>' is a type and cannot be used as an expression](visual-basic/language-reference/error-messages/typename-is-a-type-and-cannot-be-used-as-an-expression.md)
#### [A double quote is not a valid comment token for delimited fields where EscapeQuote is set to True](visual-basic/language-reference/error-messages/a-double-quote-is-not-a-valid-comment-token-for-delimited-fields.md)
#### [A property or method call cannot include a reference to a private object, either as an argument or as a return value](visual-basic/language-reference/error-messages/a-property-or-method-call-cannot-include-a-reference-to-a-private-object.md)
#### [A reference was created to embedded interop assembly '<assembly1>' because of an indirect reference to that assembly from assembly '<assembly2>'](visual-basic/language-reference/error-messages/a-reference-was-created-to-embedded-interop-assembly-assembly1.md)
#### [A startup form has not been specified](visual-basic/language-reference/error-messages/a-startup-form-has-not-been-specified.md)
#### [Access of shared member through an instance; qualifying expression will not be evaluated](visual-basic/language-reference/error-messages/access-of-shared-member-through-an-instance-qualifying-expression.md)
#### ['AddressOf' operand must be the name of a method (without parentheses)](visual-basic/language-reference/error-messages/addressof-operand-must-be-the-name-of-a-method-without-parentheses.md)
#### [An unexpected error has occurred because an operating system resource required for single instance startup cannot be acquired](visual-basic/language-reference/error-messages/an-unexpected-error-has-occurred.md)
#### [Anonymous type member name can be inferred only from a simple or qualified name with no arguments](visual-basic/language-reference/error-messages/anonymous-type-member-name-can-be-inferred-only-from-a-simple-or-qualified-name.md)
#### [Argument not optional](visual-basic/language-reference/error-messages/argument-not-optional.md)
#### [Array bounds cannot appear in type specifiers](visual-basic/language-reference/error-messages/array-bounds-cannot-appear-in-type-specifiers.md)
#### [Array declared as for loop control variable cannot be declared with an initial size](visual-basic/language-reference/error-messages/array-declared-as-for-loop-control-variable-cannot-be-declared.md)
#### [Array subscript expression missing](visual-basic/language-reference/error-messages/array-subscript-expression-missing.md)
#### [Arrays declared as structure members cannot be declared with an initial size](visual-basic/language-reference/error-messages/arrays-declared-as-structure-members-cannot-be-declared-with-an-initial-size.md)
#### ['As Any' is not supported in 'Declare' statements](visual-basic/language-reference/error-messages/as-any-is-not-supported-in-declare-statements.md)
#### [Attribute '<attributename>' cannot be applied multiple times](visual-basic/language-reference/error-messages/attribute-attributename-cannot-be-applied-multiple-times.md)
#### [Automation error](visual-basic/language-reference/error-messages/automation-error.md)
#### [Bad checksum value, non hex digits or odd number of hex digits](visual-basic/language-reference/error-messages/bad-checksum-value-non-hex-digits-or-odd-number-of-hex-digits.md)
#### [Bad DLL calling convention](visual-basic/language-reference/error-messages/bad-dll-calling-convention.md)
#### [Bad file mode](visual-basic/language-reference/error-messages/bad-file-mode.md)
#### [Bad file name or number](visual-basic/language-reference/error-messages/bad-file-name-or-number.md)
#### [Bad record length](visual-basic/language-reference/error-messages/bad-record-length.md)
#### [Because this call is not awaited, the current method continues to run before the call is completed](visual-basic/language-reference/error-messages/because-this-call-is-not-awaited-the-current-method-continues-to-run.md)
#### [Cannot convert anonymous type to expression tree because it contains a field that is used in the initialization of another field](visual-basic/language-reference/error-messages/cannot-convert-anonymous-type-to-expression-tree.md)
#### [Cannot create ActiveX Component](visual-basic/language-reference/error-messages/cannot-create-activex-component.md)
#### [Cannot refer to '<name>' because it is a member of the value-typed field '<name>' of class '<classname>' which has 'System.MarshalByRefObject' as a base class](visual-basic/language-reference/error-messages/cannot-refer-to-name-because-it-is-member-of-value-typed-field-name-of-class.md)
#### [Cannot refer to an instance member of a class from within a shared method or shared member initializer without an explicit instance of the class](visual-basic/language-reference/error-messages/cannot-refer-to-an-instance-member-of-a-class.md)
#### [Can't create necessary temporary file](visual-basic/language-reference/error-messages/can-t-create-necessary-temporary-file.md)
#### [Can't open '<filename>' for writing](visual-basic/language-reference/error-messages/can-t-open-filename-for-writing.md)
#### [Class '<classname>' cannot be found](visual-basic/language-reference/error-messages/class-classname-cannot-be-found.md)
#### [Class does not support Automation or does not support expected interface](visual-basic/language-reference/error-messages/class-does-not-support-automation-or-does-not-support-expected-interface.md)
#### ['Class' statement must end with a matching 'End Class'](visual-basic/language-reference/error-messages/class-statement-must-end-with-a-matching-end-class.md)
#### [Clipboard format is not valid](visual-basic/language-reference/error-messages/clipboard-format-is-not-valid.md)
#### [Constant expression not representable in type '<typename>'](visual-basic/language-reference/error-messages/constant-expression-not-representable-in-type-typename.md)
#### [Constants must be of an intrinsic or enumerated type, not a class, structure, type parameter, or array type](visual-basic/language-reference/error-messages/constants-must-be-of-an-intrinsic-or-enumerated-type.md)
#### [Constructor '<name>' cannot call itself](visual-basic/language-reference/error-messages/constructor-name-cannot-call-itself.md)
#### [Copying the value of 'ByRef' parameter '<parametername>' back to the matching argument narrows from type '<typename1>' to type '<typename2>'](visual-basic/language-reference/error-messages/copying-the-value-of-byref-parameter-back-to-the-matching-argument-narrows.md)
#### ['Custom' modifier is not valid on events declared without explicit delegate types](visual-basic/language-reference/error-messages/custom-modifier-is-not-valid-on-events-declared-without-explicit-delegate-types.md)
#### [Data type(s) of the type parameter(s) cannot be inferred from these arguments](visual-basic/language-reference/error-messages/data-type-s-of-the-type-parameter-s-cannot-be-inferred-from-these-arguments.md)
#### [Declaration expected](visual-basic/language-reference/error-messages/declaration-expected.md)
#### [Default property '<propertyname1>' conflicts with default property '<propertyname2>' in '<classname>' and so should be declared 'Shadows'](visual-basic/language-reference/error-messages/default-property-propertyname1-conflicts-with-default-property-propertyname2.md)
#### [Default property access is ambiguous between the inherited interface members '<defaultpropertyname>' of interface '<interfacename1>' and '<defaultpropertyname>' of interface '<interfacename2>'](visual-basic/language-reference/error-messages/default-property-access-is-ambiguous.md)
#### [Delegate class '<classname>' has no Invoke method, so an expression of this type cannot be the target of a method call](visual-basic/language-reference/error-messages/delegate-class-classname-has-no-invoke-method.md)
#### [Derived classes cannot raise base class events](visual-basic/language-reference/error-messages/derived-classes-cannot-raise-base-class-events.md)
#### [Device I/O error](visual-basic/language-reference/error-messages/device-i-o-error.md)
#### ['Dir' function must first be called with a 'PathName' argument](visual-basic/language-reference/error-messages/dir-function-must-first-be-called-with-a-pathname-argument.md)
#### [End of statement expected](visual-basic/language-reference/error-messages/end-of-statement-expected.md)
#### [Error creating assembly manifest: <error message>](visual-basic/language-reference/error-messages/error-creating-assembly-manifest-error-message.md)
#### [Error creating Win32 resources: <error message>](visual-basic/language-reference/error-messages/error-creating-win32-resources-error-message.md)
#### [Error in loading DLL](visual-basic/language-reference/error-messages/error-in-loading-dll.md)
#### [Error saving temporary Win32 resource file '<filename>': <error message>](visual-basic/language-reference/error-messages/error-saving-temporary-win32-resource-file-filename-error-message.md)
#### [Errors occurred while compiling the XML schemas in the project](visual-basic/language-reference/error-messages/errors-occurred-while-compiling-the-xml-schemas-in-the-project.md)
#### [Evaluation of expression or statement timed out](visual-basic/language-reference/error-messages/evaluation-of-expression-or-statement-timed-out.md)
#### [Event '<eventname1>' cannot implement event '<eventname2>' on interface '<interface>' because their delegate types '<delegate1>' and '<delegate2>' do not match](visual-basic/language-reference/error-messages/event-eventname1-cannot-implement-event-eventname2-on-interface.md)
#### [Events cannot be declared with a delegate type that has a return type](visual-basic/language-reference/error-messages/events-cannot-be-declared-with-a-delegate-type-that-has-a-return-type.md)
#### [Events of shared WithEvents variables cannot be handled by non-shared methods](visual-basic/language-reference/error-messages/events-of-shared-withevents-variables-cannot-be-handled-by-non-shared-methods.md)
#### [Expression does not produce a value](visual-basic/language-reference/error-messages/expression-does-not-produce-a-value.md)
#### [Expression has the type '<typename>' which is a restricted type and cannot be used to access members inherited from 'Object' or 'ValueType'](visual-basic/language-reference/error-messages/expression-has-the-type-typename-which-is-a-restricted-type.md)
#### [Expression is a value and therefore cannot be the target of an assignment](visual-basic/language-reference/error-messages/expression-is-a-value-and-therefore-cannot-be-the-target-of-an-assignment.md)
#### [Expression of type <type> is not queryable](visual-basic/language-reference/error-messages/expression-of-type-type-is-not-queryable.md)
#### [Expression recursively calls the containing property '<propertyname>'](visual-basic/language-reference/error-messages/expression-recursively-calls-the-containing-property-propertyname.md)
#### [Expression too complex](visual-basic/language-reference/error-messages/expression-too-complex.md)
#### ['Extension' attribute can be applied only to 'Module', 'Sub', or 'Function' declarations](visual-basic/language-reference/error-messages/extension-attribute-can-be-applied-only-to-module-sub-or-function-declarations.md)
#### [File already open](visual-basic/language-reference/error-messages/file-already-open.md)
#### [File is too large to read into a byte array](visual-basic/language-reference/error-messages/file-is-too-large-to-read-into-a-byte-array.md)
#### [File name or class name not found during Automation operation](visual-basic/language-reference/error-messages/file-name-or-class-name-not-found-during-automation-operation.md)
#### [File not found (Visual Basic Run-Time Error)](visual-basic/language-reference/error-messages/file-not-found-visual-basic-run-time-error.md)
#### [First operand in a binary 'If' expression must be nullable or a reference type](visual-basic/language-reference/error-messages/first-operand-in-a-binary-if-expression-must-be-nullable-or-a-reference-type.md)
#### [First statement of this 'Sub New' must be a call to 'MyBase.New' or 'MyClass.New' (No Accessible Constructor Without Parameters)](visual-basic/language-reference/error-messages/first-statement-of-this-sub-new-must-be-a-call-to-mybase-new-or-myclass-new.md)
#### [First statement of this 'Sub New' must be an explicit call to 'MyBase.New' or 'MyClass.New' because the '<constructorname>' in the base class '<baseclassname>' of '<derivedclassname>' is marked obsolete: '<errormessage>'](visual-basic/language-reference/error-messages/first-statement-of-sub-new-must-be-explicit-call-to-mybase-new-or-myclass-new.md)
#### ['For Each' on type '<typename>' is ambiguous because the type implements multiple instantiations of 'System.Collections.Generic.IEnumerable(Of T)'](visual-basic/language-reference/error-messages/for-each-on-type-typename-is-ambiguous.md)
#### [Friend assembly reference <reference> is invalid](visual-basic/language-reference/error-messages/friend-assembly-reference-reference-is-invalid.md)
#### [Function '<procedurename>' doesn't return a value on all code paths](visual-basic/language-reference/error-messages/function-procedurename-doesn-t-return-a-value-on-all-code-paths.md)
#### [Function evaluation is disabled because a previous function evaluation timed out](visual-basic/language-reference/error-messages/function-evaluation-is-disabled.md)
#### [Generic parameters used as optional parameter types must be class constrained](visual-basic/language-reference/error-messages/generic-parameters-used-as-optional-parameter-types-must-be-class-constrained.md)
#### ['Get' accessor of property '<propertyname>' is not accessible](visual-basic/language-reference/error-messages/get-accessor-of-property-propertyname-is-not-accessible.md)
#### [Handles clause requires a WithEvents variable defined in the containing type or one of its base types](visual-basic/language-reference/error-messages/handles-clause-requires-a-withevents-variable-defined.md)
#### [Identifier expected](visual-basic/language-reference/error-messages/identifier-expected.md)
#### [Identifier is too long](visual-basic/language-reference/error-messages/identifier-is-too-long.md)
#### [Initializer expected](visual-basic/language-reference/error-messages/initializer-expected.md)
#### [Input past end of file](visual-basic/language-reference/error-messages/input-past-end-of-file.md)
#### [Internal error happened at <location>](visual-basic/language-reference/error-messages/internal-error-happened-at-location.md)
#### [Implicit conversion from '<typename1>' to '<typename2>' in copying the value of 'ByRef' parameter '<parametername>' back to the matching argument.](visual-basic/language-reference/error-messages/implicit-conversion-from-typename1-to-typename2-in-copying.md)
#### ['Is' requires operands that have reference types, but this operand has the value type '<typename>'](visual-basic/language-reference/error-messages/is-requires-operands-that-have-reference-types.md)
#### ['IsNot' operand of type 'typename' can only be compared to 'Nothing', because 'typename' is a nullable type](visual-basic/language-reference/error-messages/isnot-operand-of-type-can-only-be-compared-to-nothing.md)
#### [Labels that are numbers must be followed by colons](visual-basic/language-reference/error-messages/labels-that-are-numbers-must-be-followed-by-colons.md)
#### [Lambda expression will not be removed from this event handler](visual-basic/language-reference/error-messages/lambda-expression-will-not-be-removed-from-this-event-handler.md)
#### [Lambda expressions are not valid in the first expression of a 'Select Case' statement](visual-basic/language-reference/error-messages/lambda-expressions-are-not-valid-in-the-first-expression-of-select-case.md)
#### [Late bound resolution; runtime errors could occur](visual-basic/language-reference/error-messages/late-bound-resolution;-runtime-errors-could-occur.md)
#### [Latebound overload resolution cannot be applied to '<procedurename>' because the accessing instance is an interface type](visual-basic/language-reference/error-messages/latebound-overload-resolution-cannot-be-applied.md)
#### [Leading '.' or '!' can only appear inside a 'With' statement](visual-basic/language-reference/error-messages/leading-period-or-exclamation-point-can-only-appear-inside-a-with-statement.md)
#### [Line is too long](visual-basic/language-reference/error-messages/line-is-too-long.md)
#### ['Line' statements are no longer supported (Visual Basic Compiler Error)](visual-basic/language-reference/error-messages/line-statements-are-no-longer-supported-visual-basic-compiler-error.md)
#### [Method does not have a signature compatible with the delegate](visual-basic/language-reference/error-messages/method-does-not-have-a-signature-compatible-with-the-delegate.md)
#### [Methods of 'System.Nullable(Of T)' cannot be used as operands of the 'AddressOf' operator](visual-basic/language-reference/error-messages/methods-of-system-nullable-of-t-cannot-be-used-as-operands-of-the-addressof.md)
#### ['Module' statements can occur only at file or namespace level](visual-basic/language-reference/error-messages/module-statements-can-occur-only-at-file-or-namespace-level.md)
#### [Name <membername> is not CLS-compliant](visual-basic/language-reference/error-messages/name-membername-is-not-cls-compliant.md)
#### [Name '<name>' is not declared](visual-basic/language-reference/error-messages/name-name-is-not-declared.md)
#### [Name <namespacename> in the root namespace <fullnamespacename> is not CLS-compliant](visual-basic/language-reference/error-messages/name-namespacename-in-the-root-namespace-fullnamespacename-is-not-cls-compliant.md)
#### [Namespace or type specified in the Imports '<qualifiedelementname>' doesn't contain any public member or cannot be found](visual-basic/language-reference/error-messages/namespace-or-type-specified-in-the-imports-qualifiedelementname.md)
#### [Namespace or type specified in the project-level Imports '<qualifiedelementname>' doesn't contain any public member or cannot be found](visual-basic/language-reference/error-messages/namespace-or-type-specified-in-the-project-level-imports-qualifiedelementname.md)
#### [Need property array index](visual-basic/language-reference/error-messages/need-property-array-index.md)
#### [Nested function does not have a signature that is compatible with delegate '<delegatename>'](visual-basic/language-reference/error-messages/nested-function-does-not-have-a-signature-that-is-compatible-with-delegate.md)
#### [No accessible 'Main' method with an appropriate signature was found in '<name>'](visual-basic/language-reference/error-messages/no-accessible-main-method-with-an-appropriate-signature-was-found-in-name.md)
#### [Non-CLS-compliant <membername> is not allowed in a CLS-compliant interface](visual-basic/language-reference/error-messages/non-cls-compliant-membername-is-not-allowed-in-a-cls-compliant-interface.md)
#### [Nullable type inference is not supported in this context](visual-basic/language-reference/error-messages/nullable-type-inference-is-not-supported-in-this-context.md)
#### [Number of indices exceeds the number of dimensions of the indexed array](visual-basic/language-reference/error-messages/number-of-indices-exceeds-the-number-of-dimensions-of-the-indexed-array.md)
#### [Object or class does not support the set of events](visual-basic/language-reference/error-messages/object-or-class-does-not-support-the-set-of-events.md)
#### [Object required](visual-basic/language-reference/error-messages/object-required.md)
#### [Object variable or With block variable not set](visual-basic/language-reference/error-messages/object-variable-or-with-block-variable-not-set.md)
#### [Operator declaration must be one of:  +,-,*,-,-,^, &, Like, Mod, And, Or, Xor, Not, <<, >>, =, <>, <, <=, >, >=, CType, IsTrue, IsFalse](visual-basic/language-reference/error-messages/operator-declaration-must-be-one-of.md)
#### ['Optional' expected](visual-basic/language-reference/error-messages/optional-expected.md)
#### [Optional parameters must specify a default value](visual-basic/language-reference/error-messages/optional-parameters-must-specify-a-default-value.md)
#### [Ordinal is not valid](visual-basic/language-reference/error-messages/ordinal-is-not-valid.md)
#### [Out of memory (Visual Basic Compiler Error)](visual-basic/language-reference/error-messages/out-of-memory-visual-basic-compiler-error.md)
#### [Out of stack space](visual-basic/language-reference/error-messages/out-of-stack-space.md)
#### [Out of string space](visual-basic/language-reference/error-messages/out-of-string-space.md)
#### [Overflow (Visual Basic Error)](visual-basic/language-reference/error-messages/overflow-visual-basic-error.md)
#### [Overflow (Visual Basic Run-Time Error)](visual-basic/language-reference/error-messages/overflow-visual-basic-run-time-error.md)
#### [Path not found](visual-basic/language-reference/error-messages/path-not-found.md)
#### [Path-File access error](visual-basic/language-reference/error-messages/path-file-access-error.md)
#### [Permission denied](visual-basic/language-reference/error-messages/permission-denied.md)
#### [Procedure call or argument is not valid](visual-basic/language-reference/error-messages/procedure-call-or-argument-is-not-valid.md)
#### [Property '<propertyname>' doesn't return a value on all code paths](visual-basic/language-reference/error-messages/property-propertyname-doesn-t-return-a-value-on-all-code-paths.md)
#### [Property array index is not valid](visual-basic/language-reference/error-messages/property-array-index-is-not-valid.md)
#### [Property let procedure not defined and property get procedure did not return an object](visual-basic/language-reference/error-messages/property-let-procedure-not-defined-and-property-get-procedure-did-not-return.md)
#### [Property not found](visual-basic/language-reference/error-messages/property-not-found.md)
#### [Property or method not found](visual-basic/language-reference/error-messages/property-or-method-not-found.md)
#### [Range variable <variable> hides a variable in an enclosing block, a previously defined range variable, or an implicitly declared variable in a query expression](visual-basic/language-reference/error-messages/range-variable-variable-hides-a-variable-in-an-enclosing-block.md)
#### [Range variable name can be inferred only from a simple or qualified name with no arguments](visual-basic/language-reference/error-messages/range-variable-name-can-be-inferred.md)
#### [Reference required to assembly '<assemblyidentity>' containing type '<typename>', but a suitable reference could not be found due to ambiguity between projects '<projectname1>' and '<projectname2>'](visual-basic/language-reference/error-messages/reference-required-to-assembly-containing-type-but-suitable-reference-not-found.md)
#### [Reference required to assembly '<assemblyname>' containing the base class '<classname>'](visual-basic/language-reference/error-messages/reference-required-to-assembly-assemblyname-containing-the-base-class-classname.md)
#### [Resume without error](visual-basic/language-reference/error-messages/resume-without-error.md)
#### [Return type of function '<procedurename>' is not CLS-compliant](visual-basic/language-reference/error-messages/return-type-of-function-procedurename-is-not-cls-compliant.md)
#### ['Set' accessor of property '<propertyname>' is not accessible](visual-basic/language-reference/error-messages/set-accessor-of-property-propertyname-is-not-accessible.md)
#### [Some subkeys cannot be deleted](visual-basic/language-reference/error-messages/some-subkeys-cannot-be-deleted.md)
#### [Statement cannot end a block outside of a line 'If' statement](visual-basic/language-reference/error-messages/statement-cannot-end-a-block-outside-of-a-line-if-statement.md)
#### [Statement is not valid in a namespace](visual-basic/language-reference/error-messages/statement-is-not-valid-in-a-namespace.md)
#### [Statement is not valid inside a method-multiline lambda](visual-basic/language-reference/error-messages/statement-is-not-valid-inside-a-method-multiline-lambda.md)
#### [String constants must end with a double quote](visual-basic/language-reference/error-messages/string-constants-must-end-with-a-double-quote.md)
#### [Structure '<structurename>' must contain at least one instance member variable or at least one instance event declaration not marked 'Custom'](visual-basic/language-reference/error-messages/structure-structurename-must-contain.md)
#### ['Sub Main' was not found in '<name>'](visual-basic/language-reference/error-messages/sub-main-was-not-found-in-name.md)
#### [Sub or Function not defined](visual-basic/language-reference/error-messages/sub-or-function-not-defined.md)
#### [Subscript out of range](visual-basic/language-reference/error-messages/subscript-out-of-range.md)
#### [TextFieldParser is unable to complete the read operation because maximum buffer size has been exceeded](visual-basic/language-reference/error-messages/textfieldparser-is-unable-to-complete-read-operation.md)
#### [The type for variable '<variablename>' will not be inferred because it is bound to a field in an enclosing scope](visual-basic/language-reference/error-messages/the-type-for-variable-variablename-will-not-be-inferred.md)
#### [This array is fixed or temporarily locked](visual-basic/language-reference/error-messages/this-array-is-fixed-or-temporarily-locked.md)
#### [This key is already associated with an element of this collection](visual-basic/language-reference/error-messages/this-key-is-already-associated-with-an-element-of-this-collection.md)
#### [Too many files](visual-basic/language-reference/error-messages/too-many-files.md)
#### [Type '<typename>' has no constructors](visual-basic/language-reference/error-messages/type-typename-has-no-constructors.md)
#### [Type <typename> is not CLS-compliant](visual-basic/language-reference/error-messages/type-typename-is-not-cls-compliant.md)
#### [Type '<typename>' is not defined](visual-basic/language-reference/error-messages/type-typename-is-not-defined.md)
#### [Type arguments could not be inferred from the delegate](visual-basic/language-reference/error-messages/type-arguments-could-not-be-inferred-from-the-delegate.md)
#### [Type mismatch](visual-basic/language-reference/error-messages/type-mismatch.md)
#### [Type of '<variablename>' cannot be inferred because the loop bounds and the step variable do not widen to the same type](visual-basic/language-reference/error-messages/type-of-variablename-cannot-be-inferred.md)
#### [Type of member '<membername>' is not CLS-compliant](visual-basic/language-reference/error-messages/type-of-member-membername-is-not-cls-compliant.md)
#### [Type of optional value for optional parameter <parametername> is not CLS-compliant](visual-basic/language-reference/error-messages/type-of-optional-value-for-optional-parameter-is-not-cls-compliant.md)
#### [Type of parameter '<parametername>' is not CLS-compliant](visual-basic/language-reference/error-messages/type-of-parameter-parametername-is-not-cls-compliant.md)
#### [Type parameters cannot be used as qualifiers](visual-basic/language-reference/error-messages/type-parameters-cannot-be-used-as-qualifiers.md)
#### [Unable to create strong-named assembly from key file '<filename>': <error>](visual-basic/language-reference/error-messages/unable-to-create-strong-named-assembly-from-key-file-filename-error.md)
#### [Unable to embed resource file '<filename>': <error message>](visual-basic/language-reference/error-messages/unable-to-embed-resource-file-filename-error-message.md)
#### [Unable to emit assembly: <error message>](visual-basic/language-reference/error-messages/unable-to-emit-assembly-error-message.md)
#### [Unable to find required file '<filename>'](visual-basic/language-reference/error-messages/unable-to-find-required-file-filename.md)
#### [Unable to get serial port names because of an internal system error](visual-basic/language-reference/error-messages/unable-to-get-serial-port-names-because-of-an-internal-system-error.md)
#### [Unable to link to resource file '<filename>': <error message>](visual-basic/language-reference/error-messages/unable-to-link-to-resource-file-filename-error-message.md)
#### [Unable to load information for class '<classname>'](visual-basic/language-reference/error-messages/unable-to-load-information-for-class-classname.md)
#### [Unable to write output to memory](visual-basic/language-reference/error-messages/unable-to-write-output-to-memory.md)
#### [Unable to write temporary file because temporary path is not available](visual-basic/language-reference/error-messages/unable-to-write-temporary-file-because-temporary-path-is-not-available.md)
#### [Unable to write to output file '<filename>': <error>](visual-basic/language-reference/error-messages/unable-to-write-to-output-file-filename-error.md)
#### [Underlying type <typename> of Enum is not CLS-compliant](visual-basic/language-reference/error-messages/underlying-type-typename-of-enum-is-not-cls-compliant.md)
#### [Using the iteration variable in a lambda expression may have unexpected results](visual-basic/language-reference/error-messages/using-the-iteration-variable-in-a-lambda-expression-may-have-unexpected-results.md)
#### [Value of type '<typename1>' cannot be converted to '<typename2>'](visual-basic/language-reference/error-messages/value-of-type-typename1-cannot-be-converted-to-typename2.md)
#### [Value of type '<typename1>' cannot be converted to '<typename2>' (Multiple file references)](visual-basic/language-reference/error-messages/value-of-type-typename1-cannot-be-converted-to-typename2-multiple.md)
#### [Value of type 'type1' cannot be converted to 'type2'](visual-basic/language-reference/error-messages/value-of-type-type1-cannot-be-converted-to-type2.md)
#### [Variable '<variablename>' hides a variable in an enclosing block](visual-basic/language-reference/error-messages/variable-variablename-hides-a-variable-in-an-enclosing-block.md)
#### [Variable '<variablename>' is used before it has been assigned a value](visual-basic/language-reference/error-messages/variable-variablename-is-used-before-it-has-been-assigned-a-value.md)
#### [Variable uses an Automation type not supported in Visual Basic](visual-basic/language-reference/error-messages/variable-uses-an-automation-type-not-supported.md)
#### [XML axis properties do not support late binding](visual-basic/language-reference/error-messages/xml-axis-properties-do-not-support-late-binding.md)
#### [XML comment exception must have a 'cref' attribute](visual-basic/language-reference/error-messages/xml-comment-exception-must-have-a-cref-attribute.md)
#### [XML entity references are not supported](visual-basic/language-reference/error-messages/xml-entity-references-are-not-supported.md)
#### [XML literals and XML properties are not supported in embedded code within ASP.NET](visual-basic/language-reference/error-messages/xml-literals-and-xml-properties-are-not-supported-in-embedded-code-in-aspnet.md)
#### [XML namespace URI '<uri>' can be bound only to 'xmlns'](visual-basic/language-reference/error-messages/xml-namespace-uri-uri-can-be-bound-only-to-xmlns.md)
## [Reference](visual-basic/reference/index.md)
### [Command-Line Compiler](visual-basic/reference/command-line-compiler/index.md)
#### [Building from the Command Line](visual-basic/reference/command-line-compiler/building-from-the-command-line.md)
##### [How to: Invoke the Command-Line Compiler](visual-basic/reference/command-line-compiler/how-to-invoke-the-command-line-compiler.md)
##### [Sample Compilation Command Lines](visual-basic/reference/command-line-compiler/sample-compilation-command-lines.md)
#### [Compiler Options Listed Alphabetically](visual-basic/reference/command-line-compiler/compiler-options-listed-alphabetically.md)
##### [@ (Specify Response File)](visual-basic/reference/command-line-compiler/specify-response-file.md)
##### [/addmodule](visual-basic/reference/command-line-compiler/addmodule.md)
##### [/baseaddress](visual-basic/reference/command-line-compiler/baseaddress.md)
##### [/bugreport](visual-basic/reference/command-line-compiler/bugreport.md)
##### [/codepage](visual-basic/reference/command-line-compiler/codepage.md)
##### [/debug](visual-basic/reference/command-line-compiler/debug.md)
##### [/define](visual-basic/reference/command-line-compiler/define.md)
##### [/delaysign](visual-basic/reference/command-line-compiler/delaysign.md)
##### [/doc](visual-basic/reference/command-line-compiler/doc.md)
##### [/errorreport](visual-basic/reference/command-line-compiler/errorreport.md)
##### [/filealign](visual-basic/reference/command-line-compiler/filealign.md)
##### [/help, /?](visual-basic/reference/command-line-compiler/help.md)
##### [/highentropyva](visual-basic/reference/command-line-compiler/highentropyva.md)
##### [/imports](visual-basic/reference/command-line-compiler/imports.md)
##### [/keycontainer](visual-basic/reference/command-line-compiler/keycontainer.md)
##### [/keyfile](visual-basic/reference/command-line-compiler/keyfile.md)
##### [/langversion](visual-basic/reference/command-line-compiler/langversion.md)
##### [/libpath](visual-basic/reference/command-line-compiler/libpath.md)
##### [/link](visual-basic/reference/command-line-compiler/link.md)
##### [/linkresource](visual-basic/reference/command-line-compiler/linkresource.md)
##### [/main](visual-basic/reference/command-line-compiler/main.md)
##### [/moduleassemblyname](visual-basic/reference/command-line-compiler/moduleassemblyname.md)
##### [/netcf](visual-basic/reference/command-line-compiler/netcf.md)
##### [/noconfig](visual-basic/reference/command-line-compiler/noconfig.md)
##### [/nologo](visual-basic/reference/command-line-compiler/nologo.md)
##### [/nostdlib](visual-basic/reference/command-line-compiler/nostdlib.md)
##### [/nowarn](visual-basic/reference/command-line-compiler/nowarn.md)
##### [/nowin32manifest](visual-basic/reference/command-line-compiler/nowin32manifest.md)
##### [/optimize](visual-basic/reference/command-line-compiler/optimize.md)
##### [/optioncompare](visual-basic/reference/command-line-compiler/optioncompare.md)
##### [/optionexplicit](visual-basic/reference/command-line-compiler/optionexplicit.md)
##### [/optioninfer](visual-basic/reference/command-line-compiler/optioninfer.md)
##### [/optionstrict](visual-basic/reference/command-line-compiler/optionstrict.md)
##### [/out](visual-basic/reference/command-line-compiler/out.md)
##### [/platform](visual-basic/reference/command-line-compiler/platform.md)
##### [/quiet](visual-basic/reference/command-line-compiler/quiet.md)
##### [/recurse](visual-basic/reference/command-line-compiler/recurse.md)
##### [/reference](visual-basic/reference/command-line-compiler/reference.md)
##### [/removeintchecks](visual-basic/reference/command-line-compiler/removeintchecks.md)
##### [/resource](visual-basic/reference/command-line-compiler/resource.md)
##### [/rootnamespace](visual-basic/reference/command-line-compiler/rootnamespace.md)
##### [/sdkpath](visual-basic/reference/command-line-compiler/sdkpath.md)
##### [/target](visual-basic/reference/command-line-compiler/target.md)
##### [/subsystemversion](visual-basic/reference/command-line-compiler/subsystemversion.md)
##### [/utf8output](visual-basic/reference/command-line-compiler/utf8output.md)
##### [/vbruntime](visual-basic/reference/command-line-compiler/vbruntime.md)
##### [/verbose](visual-basic/reference/command-line-compiler/verbose.md)
##### [/warnaserror](visual-basic/reference/command-line-compiler/warnaserror.md)
##### [/win32icon](visual-basic/reference/command-line-compiler/win32icon.md)
##### [/win32manifest](visual-basic/reference/command-line-compiler/win32manifest.md)
##### [/win32resource](visual-basic/reference/command-line-compiler/win32resource.md)
#### [Compiler Options Listed by Category](visual-basic/reference/command-line-compiler/compiler-options-listed-by-category.md)
### [.NET Framework Reference Information](visual-basic/reference/net-framework-reference-information.md)
### [Language Specification](visual-basic/reference/language-specification.md)
## [Sample Applications](visual-basic/sample-applications.md)
## [Walkthroughs](visual-basic/walkthroughs.md)

<!-- End of VB Content -->

# [Samples and Tutorials](samples-and-tutorials/index.md)
