---
title: "Accessing data in Visual Basic applications | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "data [Visual Basic]"
  - "Visual Basic, data access"
ms.assetid: 3086ab38-3be5-4b22-9385-7d0e16b04f6a
caps.latest.revision: 23
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Accessing data in Visual Basic applications
[!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] includes several new features to assist in developing applications that access data. Data-bound forms for Windows applications are created by dragging items from the [Data Sources Window](https://docs.microsoft.com/visualstudio/data-tools/bind-controls-to-data-in-visual-studio) onto the form. You bind controls to data by dragging items from the **Data Sources Window** onto existing controls.  
  
## Related sections  
 [Creating Data Applications](https://docs.microsoft.com/visualstudio/data-tools/creating-data-applications)  
 Provides links to pages that discuss incorporating data access functionality into your applications.

 [Overview of Data Applications in Visual Studio](https://docs.microsoft.com/visualstudio/data-tools/overview-of-data-applications-in-visual-studio)  
 Provides links to pages on creating applications that work with data, using [!INCLUDE[vsprvs](../../csharp/includes/vsprvs_md.md)].  
  
 [LINQ](../../visual-basic/programming-guide/language-features/linq/index.md)  
 Provides links to topics that describe how to use LINQ with Visual Basic.  
  
 [LINQ to SQL](https://msdn.microsoft.com/library/bb386976)  
 Provides information about [!INCLUDE[vbtecdlinq](../../csharp/includes/vbtecdlinq_md.md)]. Includes programming examples.  
  
 [LINQ to SQL Tools in Visual Studio](https://docs.microsoft.com/visualstudio/data-tools/linq-to-sql-tools-in-visual-studio2)  
 Provides links to topics about how to create a [LINQ to SQL](https://msdn.microsoft.com/library/bb386976) object model in applications.  
  
 [Work with datasets in n-tier applications](https://docs.microsoft.com/visualstudio/data-tools/work-with-datasets-in-n-tier-applications)  
 Provides links to topics about how to create multitiered data applications.  
     
 [Connecting to Data in Visual Studio](https://docs.microsoft.com/visualstudio/data-tools/connecting-to-data-in-visual-studio)  
 Provides links to pages on connecting your application to data with design-time tools and ADO.NET connection objects, using [!INCLUDE[vsprvs](../../csharp/includes/vsprvs_md.md)].  

 [Fetching Data into Your Application](https://docs.microsoft.com/visualstudio/data-tools/fetching-data-into-your-application)  
 Provides links to pages describing how to load data into datasets and how to execute SQL statements and stored procedures.  
  
 [Bind controls to data in Visual Studio](https://docs.microsoft.com/visualstudio/data-tools/bind-controls-to-data-in-visual-studio)  
 Provides links to pages that explain how to display data on Windows Forms through data-bound controls.  
  
 [Editing Data in Your Application](https://docs.microsoft.com/visualstudio/data-tools/editing-data-in-your-application)  
 Provides links to pages describing how to manipulate the data in the data tables of a dataset.  
  
 [Validate data in datasets](https://docs.microsoft.com/visualstudio/data-tools/validate-data-in-datasets)  
 Provides links to pages describing how to add validation to a dataset during column and row changes.  
  
 [Saving Data](https://docs.microsoft.com/visualstudio/data-tools/saving-data)  
 Provides links to pages explaining how to send updated data from an application to the database.  
  
 [ADO.NET](https://msdn.microsoft.com/library/e80y5yhx.aspx)  
 Describes the ADO.NET classes, which expose data-access services to the .NET Framework programmer.

 [Data in Office Solutions](https://msdn.microsoft.com/library/xx069ybh)  
 Contains links to pages that explain how data works in Office solutions, including information about schema-oriented programming, data caching, and server-side data access.