---
title: "File Access with Visual Basic | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "file access"
  - "files, input and output"
  - "file access, Visual Basic"
  - "files, I/O"
  - "file I/O classes"
  - "data [Visual Basic], accessing from files"
  - "files, accessing"
  - "file access, using components"
  - "My.Computer.FileSystem object, accessing files"
  - "I/O [Visual Basic]"
  - "sequential access"
ms.assetid: 231533bf-d049-4345-befa-3fb78fe6517d
caps.latest.revision: 17
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# File Access with Visual Basic
The `My.Computer.FileSystem` object provides tools for working with files and folders. Its properties, methods, and events allow you to create, copy, move, investigate, and delete files and folders. `My.Computer.FileSystem` provides better performance than the legacy functions (`FileOpen`, `FileClose`, `Input`, `InputString`, `LineInput`, etc.) that are provided by [!INCLUDE[vbprvb](../../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] for backward compatibility.  
  
## In This Section  
 [Reading from Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/reading-from-files.md)  
 Lists topics dealing with using the `My.Computer.FileSystem` object to read from files  
  
 [Writing to Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/writing-to-files.md)  
 Lists topics dealing with using the `My.Computer.FileSystem` object to write to files  
  
 [Creating, Deleting, and Moving Files and Directories](../../../../visual-basic/developing-apps/programming/drives-directories-files/creating-deleting-and-moving-files-and-directories.md)  
 Lists topics dealing with using the `My.Computer.FileSystem` object to creating, copying, deleting and moving files and folders.  
  
 [Parsing Text Files with the TextFieldParser Object](../../../../visual-basic/developing-apps/programming/drives-directories-files/parsing-text-files-with-the-textfieldparser-object.md)  
 Discusses how to use the `TextFieldReader` to parse text files such as logs.  
  
 [File Encodings](../../../../visual-basic/developing-apps/programming/drives-directories-files/file-encodings.md)  
 Describes file encodings and their use.  
  
 [Walkthrough: Manipulating Files and Directories in Visual Basic](../../../../visual-basic/developing-apps/programming/drives-directories-files/walkthrough-manipulating-files-and-directories.md)  
 Demonstrates how to create a utility that reports information about files and folders.  
  
 [Troubleshooting: Reading from and Writing to Text Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/troubleshooting-reading-from-and-writing-to-text-files.md)  
 Lists common problems encountered when reading and writing to text files, and suggests remedies for each.