# [Processing Drives, Directories, and Files](processing.md)
## [File Access with Visual Basic](file-access.md)
### [Reading from Files](reading-from-files.md)
#### [How to: Read From Text Files](how-to-read-from-text-files.md)
#### [How to: Read From Comma-Delimited Text Files](how-to-read-from-comma-delimited-text-files.md)
#### [How to: Read From Fixed-width Text Files](how-to-read-from-fixed-width-text-files.md)
#### [How to: Read From Text Files with Multiple Formats](how-to-read-from-text-files-with-multiple-formats.md)
#### [How to: Read From Binary Files](how-to-read-from-binary-files.md)
#### [How to: Read Text from Files with a StreamReader](how-to-read-text-from-files-with-a-streamreader.md)
### [Writing to Files](writing-to-files.md)
#### [How to: Write Text to Files](how-to-write-text-to-files.md)
#### [How to: Append to Text Files](how-to-append-to-text-files.md)
#### [How to: Write to Binary Files](how-to-write-to-binary-files.md)
#### [How to: Write Text to Files in the My Documents Directory](how-to-write-text-to-files-in-the-my-documents-directory.md)
#### [How to: Write Text to Files with a StreamWriter](how-to-write-text-to-files-with-a-streamwriter.md)
### [Creating, Deleting, and Moving Files and Directories](creating-deleting-and-moving-files-and-directories.md)
#### [How to: Copy Files with a Specific Pattern to a Directory](how-to-copy-files-with-a-specific-pattern-to-a-directory.md)
#### [How to: Create a Copy of a File in the Same Directory](how-to-create-a-copy-of-a-file-in-the-same-directory.md)
#### [How to: Create a Copy of a File in a Different Directory](how-to-create-a-copy-of-a-file-in-a-different-directory.md)
#### [How to: Create a File](how-to-create-a-file.md)
#### [How to: Delete a File](how-to-delete-a-file.md)
#### [How to: Find Files with a Specific Pattern](how-to-find-files-with-a-specific-pattern.md)
#### [How to: Move a File](how-to-move-a-file.md)
#### [How to: Rename a File](how-to-rename-a-file.md)
#### [How to: Copy a Directory to Another Directory](how-to-copy-a-directory-to-another-directory.md)
#### [How to: Create a Directory](how-to-create-a-directory.md)
#### [How to: Find Subdirectories with a Specific Pattern](how-to-find-subdirectories-with-a-specific-pattern.md)
#### [How to: Get the Collection of Files in a Directory](how-to-get-the-collection-of-files-in-a-directory.md)
#### [How to: Retrieve the Contents of the My Documents Directory](how-to-retrieve-the-contents-of-the-my-documents-directory.md)
#### [How to: Parse File Paths](how-to-parse-file-paths.md)
### [Parsing Text Files with the TextFieldParser Object](parsing-text-files-with-the-textfieldparser-object.md)
### [File Encodings](file-encodings.md)
### [Troubleshooting: Reading from and Writing to Text Files](troubleshooting-reading-from-and-writing-to-text-files.md)
## [Basics of .NET Framework File I/O and the File System](basics-of-net-framework-file-io-and-the-file-system.md)
### [Classes Used in .NET Framework File I/O and the File System](classes-used-in-net-framework-file-io-and-the-file-system.md)
## [Walkthrough: Manipulating Files by Using .NET Framework Methods](walkthrough-manipulating-files-by-using-net-framework-methods.md)
## [Walkthrough: Manipulating Files and Directories](walkthrough-manipulating-files-and-directories.md)
