---
title: "Programming in Visual Basic | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net

ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "programming, Visual Basic"
  - "programming"
ms.assetid: bc45a3de-ea36-46e6-a106-309a413d7804
caps.latest.revision: 11
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Programming in Visual Basic
This section discusses programming tasks that you may want to learn more about as you create your Visual Basic application.  
  
## In this section  
 [Accessing Computer Resources](../../../visual-basic/developing-apps/programming/computer-resources/computer-resources.md)  
 Contains documentation on how to use the `My.Computer` object to access information about the computer on which an application runs and how to control the computer.  
  
 [Logging Information from the Application](../../../visual-basic/developing-apps/programming/log-info/logging-information-from-the-application.md)  
 Contains documentation on how to log information from your application using the `My.Application.Log` and `My.Log` objects, and how to extend the application's logging capabilities.  
  
 [Accessing User Data](../../../visual-basic/developing-apps/programming/accessing-user-data.md)  
 Contains documentation on tasks that you can accomplish using the `My.User` object.  
  
 [Accessing Application Forms](../../../visual-basic/developing-apps/programming/accessing-application-forms.md)  
 Contains documentation on accessing an application's forms by using the `My.Forms` and `My.Application` objects.  
  
 [Accessing Application Web Services](../../../visual-basic/developing-apps/programming/accessing-application-web-services.md)  
 Contains documentation on how to access the Web services referenced by the application using the `My.WebServices` object.  
  
 [Accessing Application Settings](../../../visual-basic/developing-apps/programming/app-settings/accessing-application-settings.md)  
 Contains documentation on accessing an application's settings using the `My.Settings` object.  
  
 [Processing Drives, Directories, and Files](../../../visual-basic/developing-apps/programming/drives-directories-files/processing.md)  
 Contains documentation on how to access the file system using the `My.Computer.FileSystem` object.  
  
## See Also  
 [Visual Basic Language Features](../../../visual-basic/programming-guide/language-features/index.md)   
 [Programming Concepts](../../../visual-basic/programming-guide/concepts/index.md)   
 [Collections](../../../visual-basic/programming-guide/concepts/collections.md)   
 [Developing Applications with Visual Basic](../../../visual-basic/developing-apps/index.md)