---
title: "Using the Visual Basic Development Environment | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net

ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
ms.assetid: 1509c90a-0b5a-4394-b54b-94677614bd75
caps.latest.revision: 16
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Using the Visual Basic Development Environment
In addition to the core user interface features that Visual Studio provides, the Visual Basic integrated development environment (IDE) adds some to help with productivity and ease of use.  
  
## In This Section  
 [Visual Basic Settings](../../../visual-basic/developing-apps/using-ide/settings.md)  
 Describes how to optimize your experience working in the development environment.  
  
 [Visual Basic IntelliSense Code Snippets](../../../visual-basic/developing-apps/using-ide/intellisense-code-snippets.md)  
 Introduces a library of code that you can access from within the development environment.  
  
 [Help for Event Handlers in Visual Basic Code](../../../visual-basic/developing-apps/using-ide/help-for-event-handlers.md)  
 Demonstrates how to get F1 Help on an event handler.  
  
 [How to: Compile and Run a Project](../../../visual-basic/developing-apps/using-ide/how-to-compile-and-run-a-project.md)  
 Describes your options for compiling and running from within the development environment.

## Related Topics

 [Refactoring](https://docs.microsoft.com/visualstudio/vb-ide/refactoring-vb)  
 Describes the the process of improving your code after it has been written by changing the internal structure of the code without changing the external behavior of the code.

 [Code Generation](https://docs.microsoft.com/visualstudio/vb-ide/code-generation-vb)
 Describes how Visual Studio can help generate portions of source code for you.
  
## Reference  
 [Default Keyboard Shortcuts](https://docs.microsoft.com/visualstudio/ide/default-keyboard-shortcuts-in-visual-studio)  
 Describes the default keyboard shortcut combinations that you can use to perform actions without using a mouse.  
  
 [Edit and Continue (Visual Basic)](https://docs.microsoft.com/visualstudio/debugger/edit-and-continue-visual-basic)  
 Discusses the debugging feature that enables you to make changes to your code while it is executing in Break mode.  
  
 [Configuring Warnings in Visual Basic](https://docs.microsoft.com/visualstudio/ide/configuring-warnings-in-visual-basic)  
 Describes how you can turn warnings off or have warnings treated as error messages.