---
title: "Additional Resources for Visual Basic Programmers | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "Visual Basic, additional resources"
  - "Help"
  - "resources [Visual Basic], additional"
  - "Help, newsgroups"
  - "Web sites, Visual Studio"
  - "webcasts"
  - "Help, Visual Basic Web sites"
  - "newsgroups, Visual Studio"
  - "support, Visual Studio sites"
  - "Visual Basic, videos"
ms.assetid: 9bfb42e9-327f-439b-935e-8884f6aca80c
caps.latest.revision: 22
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Additional Resources for Visual Basic Programmers
The following web sites provide guidance and can help you find answers to common problems.  
  
## Microsoft Resources  
  
### On the Web  
  
|Term|Definition|  
|----------|----------------|  
|[Microsoft Visual Basic Developer Center](http://go.microsoft.com/fwlink/?LinkID=47768)|Provides code samples, upgrade information, videos, free downloads, and technical content.|  
|[Microsoft Visual Basic Team Blog](http://go.microsoft.com/fwlink/?LinkID=123815)|Provides access to the Visual Basic team blog.|  
|[Microsoft ASP.NET](http://go.microsoft.com/fwlink/?LinkID=51657)|Provides articles, demonstrations, tool previews, and other information for Web development in Visual Basic.|  
|[MSDN Magazine](http://msdn.microsoft.com/magazine/cc159292.aspx)|Provides in-depth articles about Visual Basic.|  
|[Microsoft patterns & practices](http://msdn.microsoft.com/practices/default.aspx)|Provides applied engineering guidance that includes production quality source code and documentation.|  
  
### Code Samples  
  
|Term|Definition|  
|----------|----------------|  
|[Code Gallery](http://code.msdn.microsoft.com/)|Download and share sample applications and other resources with the developer community.|  
|[CodePlex](http://www.codeplex.com/)|Hosts open source software projects. You can use CodePlex to find open source software or create new projects to share with the world.|  
|[Visual Basic Code Samples](http://msdn.microsoft.com/vbasic/ms789074)|Provides application, web, and data samples in Visual Basic.|  
  
### Forums  
  
|Term|Definition|  
|----------|----------------|  
|[Visual Basic Language](http://go.microsoft.com/fwlink/?LinkId=145963)|Discusses the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] language syntax and compiler.|  
|[Visual Basic Interop and Upgrade](http://go.microsoft.com/fwlink/?LinkId=145966)|Discusses upgrading to [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] and working with interoperability features.|  
|[Visual Basic IDE](http://go.microsoft.com/fwlink/?LinkId=145971)|Discusses working in the [!INCLUDE[vsprvs](../../csharp/includes/vsprvs_md.md)] integrated development environment.|  
|[Visual Basic Power Packs](http://social.msdn.microsoft.com/Forums/vbpowerpacks/threads)|Discusses the add-ins, controls, components, samples and tools that are part of the Visual Basic Power Packs.|  
|[Visual Basic General](http://go.microsoft.com/fwlink/?LinkId=145973)|Discusses issues with [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] that are not discussed in other forums.|  
  
### Chats and Discussion Groups  
  
|Term|Definition|  
|----------|----------------|  
|[MSDN Discussion Groups](http://go.microsoft.com/fwlink/?LinkId=145961)|Provides a newsgroup experience, allowing you to connect as a community with experts from around the world.|  
|[MSDN Chats](http://go.microsoft.com/fwlink/?LinkId=145962)|Provides discussions about Microsoft products or technologies. Each chat is hosted by one or more Microsoft experts. Transcripts are available for completed chats.|  
  
### Videos and Webcasts  
  
|Term|Definition|  
|----------|----------------|  
|[Channel9](http://go.microsoft.com/fwlink/?LinkID=123827)|Provides continuous community through videos, Wikis, and forums.|  
|[I'm a VB](http://msdn.microsoft.com/vbasic/dd776132)|Watch these interviews and discover what the experts love about Visual Basic and Visual Studio.|  
  
### Support  
  
|Term|Definition|  
|----------|----------------|  
|[Microsoft Help and Support](http://go.microsoft.com/fwlink/?LinkID=108287)|Provides access to Knowledge Base (KB) articles, downloads and updates, support webcasts, and other services.|  
|[Microsoft Connect](http://connect.microsoft.com/)|Enables you to file bugs or provide suggestions to Microsoft about Visual Studio. You can also report a bug by choosing **Report a Bug** on the **Help** menu.|  
  
## Third-Party Resources  
 The MSDN web site provides information on current third-party sites and newsgroups of interest. For the most current list of resources available, see the [MSDN Visual Basic Community Web](http://go.microsoft.com/fwlink/?LinkID=77372) site.  
  
|Term|Definition|  
|----------|----------------|  
|[DevX Visual Basic Zone](http://go.microsoft.com/fwlink/?LinkId=145978)|Provides in-depth technical articles for today's Visual Basic developer.|  
|[vb.dotnet.technical](http://go.microsoft.com/fwlink/?LinkId=145986)|Provides a forum for discussion of new features in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] in the DevX forums.|  
  
## See Also  
 [Getting Started](../../visual-basic/getting-started/index.md)   
 [Talk to Us](https://docs.microsoft.com/visualstudio/ide/talk-to-us)