---
title: "Visual Basic Language Reference | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "Visual Basic language reference"
  - "run-time libraries, Visual Basic"
  - "libraries, Visual Basic run-time"
  - "Visual Basic code, run-time libraries"
  - "Visual Basic code, language reference"
  - "language reference, Visual Basic"
  - "Visual Basic, language reference"
ms.assetid: 5c6bd31a-9542-4f3e-bfd5-e951af58f0f2
caps.latest.revision: 17
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Visual Basic Language Reference
This section provides reference information for various aspects of the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] language.  
  
## In This Section  
 [Typographic and Code Conventions](../../visual-basic/language-reference/typographic-and-code-conventions.md)  
 Summarizes the way that keywords, placeholders, and other elements of the language are formatted in the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] documentation.  
  
 [Visual Basic Runtime Library Members](../../visual-basic/language-reference/runtime-library-members.md)  
 Lists the classes and modules of the <xref:Microsoft.VisualBasic?displayProperty=fullName> namespace, with links to their member functions, methods, properties, constants, and enumerations.  
  
 [Keywords](../../visual-basic/language-reference/keywords/index.md)  
 Lists all Visual Basic keywords and provides links to more information.  
  
 [Attributes (Visual Basic)](../../visual-basic/language-reference/attributes.md)  
 Documents the attributes available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Constants and Enumerations](../../visual-basic/language-reference/constants-and-enumerations.md)  
 Documents the constants and enumerations available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Data Types](../../visual-basic/language-reference/data-types/data-type-summary.md)  
 Documents the data types available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Directives](../../visual-basic/language-reference/directives/directives.md)  
 Documents the compiler directives available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Functions](../../visual-basic/language-reference/functions/index.md)  
 Documents the run-time functions available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Modifiers](../../visual-basic/language-reference/modifiers/index.md)  
 Lists the Visual Basic run-time modifiers and provides links to more information.  
  
 [Modules](../../visual-basic/language-reference/modules.md)  
 Documents the modules available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] and their members.  
  
 [Nothing](../../visual-basic/language-reference/nothing.md)  
 Describes the default value of any data type.  
  
 [Objects](../../visual-basic/language-reference/objects/index.md)  
 Documents the objects available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] and their members.  
  
 [Operators](../../visual-basic/language-reference/operators/index.md)  
 Documents the operators available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Properties](../../visual-basic/language-reference/properties.md)  
 Documents the properties available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [Queries](../../visual-basic/language-reference/queries/queries.md)  
 Provides reference information about using [!INCLUDE[vbteclinqext](../../csharp/getting-started/includes/vbteclinqext_md.md)] expressions in your code.  
  
 [Statements](../../visual-basic/language-reference/statements/index.md)  
 Documents the declaration and executable statements available in [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)].  
  
 [XML Comment Tags](../../visual-basic/language-reference/xmldoc/recommended-xml-tags-for-documentation-comments.md)  
 Describes the documentation comments for which IntelliSense is provided in the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] Code Editor.  
  
 [XML Axis Properties](../../visual-basic/language-reference/xml-axis/xml-axis-properties.md)  
 Provides links to information about using XML axis properties to access XML directly in your code.  
  
 [XML Literals](../../visual-basic/language-reference/xml-literals/index.md)  
 Provides links to information about using XML literals to incorporate XML directly in your code.  
  
 [Error Messages](../../visual-basic/language-reference/error-messages/index.md)  
 Provides a listing of [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] compiler and run-time error messages and help on how to handle them.  
  
## Related Sections  
 [Visual Basic](../../visual-basic/index.md)  
 Provides comprehensive help on all areas of the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] language.  
  
 [Visual Basic Command-Line Compiler](../../visual-basic/reference/command-line-compiler/index.md)  
 Describes how to use the command-line compiler as an alternative to compiling programs from within the [!INCLUDE[vsprvs](../../csharp/includes/vsprvs_md.md)] integrated development environment (IDE).