---
title: "&#39;AddressOf&#39; expression cannot be converted to &#39;&lt;typename&gt;&#39; because &#39;&lt;typename&gt;&#39; is not a delegate type | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc30581"
  - "bc30581"
helpviewer_keywords: 
  - "BC30581"
ms.assetid: 5db7589a-5456-4b3a-9d6b-93d9157f0484
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;AddressOf&#39; expression cannot be converted to &#39;&lt;typename&gt;&#39; because &#39;&lt;typename&gt;&#39; is not a delegate type
A statement attempts to convert an `AddressOf` expression to a type that is not a delegate type.  
  
 The `AddressOf` operator creates a procedure delegate instance that references a specific procedure. `AddressOf` can be used as the operand of a delegate constructor, or it can be used in a context in which the type of the delegate can be determined by the compiler.  
  
 **Error ID:** BC30581  
  
## To correct this error  
  
-   Change the target type to a delegate type.  
  
## See Also  
 [AddressOf Operator](../../visual-basic/language-reference/operators/addressof-operator.md)   
 [NOT IN BUILD: Delegates and the AddressOf Operator](http://msdn.microsoft.com/en-us/7b2ed932-8598-4355-b2f7-5cedb23ee86f)