---
title: "&#39;&lt;elementname&gt;&#39; for the Imports alias to &#39;&lt;qualifiedelementname&gt;&#39; does not refer to a Namespace, Class, Structure, Interface, Enum or Module | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc30798"
  - "vbc30798"
helpviewer_keywords: 
  - "BC30798"
ms.assetid: bfa66627-516a-4955-977d-92372bcea090
caps.latest.revision: 7
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;&lt;elementname&gt;&#39; for the Imports alias to &#39;&lt;qualifiedelementname&gt;&#39; does not refer to a Namespace, Class, Structure, Interface, Enum or Module
An [Imports Statement (.NET Namespace and Type)](../../visual-basic/language-reference/statements/imports-statement-net-namespace-and-type.md) specifies a programming element that cannot be imported.  
  
 The `Imports` statement is used to reduce or remove the need for a qualifying string in front of an element name. You qualify the element in the `Imports` statement itself to provide an unambiguous path to a unique declaration of the element. Thereafter, you do not need to qualify references to the element.  
  
 `Imports` is most commonly used for namespaces, but you can also import a class, module, structure, interface, or enumeration to allow reference to its elements without a long qualifying string.  
  
 For more information, see "Importing Containing Elements" in [NOTINBUILD: Resolving a Reference When Multiple Variables Have the Same Name](http://msdn.microsoft.com/en-us/9601e39f-1911-44e1-ace5-3f6e090408b9).  
  
 **Error ID:** BC30798  
  
## To correct this error  
  
1.  Check the spelling of the elements in the qualification string in the `Imports` statement, especially the last element in the string, which is the element you are qualifying.  
  
2.  Verify that the element you are qualifying is of an eligible type (namespace, class, module, structure, interface, or enumeration). If it is not, remove the `Imports` statement.  
  
## See Also  
 [References and the Imports Statement](../../visual-basic/programming-guide/program-structure/references-and-the-imports-statement.md)