---
title: "Constraints for this type parameter do not match the constraints on the corresponding type parameter defined on one of the other partial types of &#39;|1&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc30932"
  - "bc30932"
helpviewer_keywords: 
  - "BC30932"
ms.assetid: a38ca4ad-6bbf-421e-a0d7-c5e0a9029160
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Constraints for this type parameter do not match the constraints on the corresponding type parameter defined on one of the other partial types of &#39;|1&#39;
When you divide the definition of a class or structure among several declarations, the compiler treats the class or structure as the union of all its partial declarations. Because of this, you cannot define any conflicting modifiers or type parameter lists in the various partial declarations.  
  
 **Error ID:** BC30932  
  
## To correct this error  
  
1.  Determine which type parameter list is the desired one for your class or structure. This includes the parameters, their order, and their constraint lists.  
  
2.  Make sure every partial definition uses the identical type parameter list.  
  
## See Also  
 [Partial](../../visual-basic/language-reference/modifiers/partial.md)   
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)