---
title: "Member &#39;&lt;classname&gt;.&lt;procedurename&gt;&#39; that matches this signature cannot be overridden because the class &#39;&lt;classname&gt;&#39; contains multiple members with this same name and signature: &lt;signaturelist&gt; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc30935"
  - "vbc30935"
helpviewer_keywords: 
  - "BC30935"
ms.assetid: 1165b630-668d-417d-9e18-9b8ffe7f6980
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Member &#39;&lt;classname&gt;.&lt;procedurename&gt;&#39; that matches this signature cannot be overridden because the class &#39;&lt;classname&gt;&#39; contains multiple members with this same name and signature: &lt;signaturelist&gt;
A procedure or property attempts to override an inherited procedure or property, but the compiler finds more than one version of the base procedure or property with the same name and signature.  
  
 This error can occur in a situation with constructed generic types, as the following skeleton declarations illustrate.  
  
```  
Public Class baseClass(Of t)  
    Public Overridable Sub doSomething(ByVal inputValue As String)  
    End Sub  
    Public Overridable Sub doSomething(ByVal inputValue As t)  
    End Sub  
End Class  
Public Class derivedClass  
    Inherits baseClass(Of String)  
    Overrides Sub doSomething(ByVal inputValue As String)  
    End Sub  
End Class  
```  
  
 Because `derivedClass` inherits `baseClass` supplying `String` to its type parameter `t`, the two versions of `doSomething` in `baseClass` take on identical signatures as far as `derivedClass` is concerned. As a result, the compiler cannot determine which version to override.  
  
 **Error ID:** BC30935  
  
## To correct this error  
  
-   Change the type argument or arguments you supply to the base class so that it does not result in one or more identical signatures of member procedures or properties.  
  
     -or-  
  
-   If you need to inherit the base class with the set of type arguments you are using, then do not override the procedure or property cited in this error message.  
  
## See Also  
 [Overridable](../../visual-basic/language-reference/modifiers/overridable.md)   
 [Overrides](../../visual-basic/language-reference/modifiers/overrides.md)   
 [NOT IN BUILD: Overriding Properties and Methods](http://msdn.microsoft.com/en-us/2167e8f5-1225-4b13-9ebd-02591ba90213)