---
title: "&#39;Set&#39; parameter must have the same type as the containing property | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc31064"
  - "bc31064"
helpviewer_keywords: 
  - "BC31064"
ms.assetid: f0b8310d-68a1-4989-ac64-03b1861528ad
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Set&#39; parameter must have the same type as the containing property
The parameter for the `Set` property procedure has a different type from the property that it belongs to.  
  
 **Error ID:** BC31064  
  
## To correct this error  
  
-   Change the data type of the parameter to `Set` so that it matches the data type for the property. For example:  
  
    ```  
    Class Class1  
       ' Declare a local variable to hold the property value.  
       Private Fval As Integer  
  
       Property F() As Integer  
          Get  
             Return Fval  
          End Get  
          Set(ByVal Value As Integer)  
             Fval = Value  
          End Set  
       End Property  
    End Class  
    ```  
  
## See Also  
 [NOT IN BUILD: How to: Add Fields and Properties to a Class](http://msdn.microsoft.com/en-us/ae53f61b-3abc-413e-8931-703c5f5e8fc2)   
 [Property Procedures](../../visual-basic/programming-guide/language-features/procedures/property-procedures.md)   
 [NOT IN BUILD: Properties and Property Procedures](http://msdn.microsoft.com/en-us/23e2a1ec-7e9d-4109-8940-c703d981077b)