---
title: "Implementing class &#39;&lt;underlyingclassname&gt;&#39; for interface &#39;&lt;interfacename&gt;&#39; is not accessible in this context because it is &#39;&lt;accesslevel&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "BC31109"
  - "vbc31109"
helpviewer_keywords: 
  - "BC31109"
ms.assetid: ab2a3bc3-b875-476f-b601-3e736ad2677e
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Implementing class &#39;&lt;underlyingclassname&gt;&#39; for interface &#39;&lt;interfacename&gt;&#39; is not accessible in this context because it is &#39;&lt;accesslevel&gt;&#39;
An interface is declared with the <xref:System.Runtime.InteropServices.CoClassAttribute> specifying an underlying class, but that class has an access level that prevents the using code from accessing it.  
  
 Applying the <xref:System.Runtime.InteropServices.CoClassAttribute> to an interface associates an underlying class with the interface. This allows code to create an object directly from the interface using a `New` clause.  
  
 If the code using the `New` clause does not have access to the underlying class, for example if the class is `Private`, then the compiler generates this error.  
  
 **Error ID:** BC31109  
  
## To correct this error  
  
1.  If you have source control over the underlying class, then adjust its access level so the using code can access it.  
  
2.  If for any reason you cannot change the access level of the underlying class, then remove the `New` clause. You cannot create an object directly from this interface.  
  
## See Also  
 <xref:System.Runtime.InteropServices.CoClassAttribute>   
 [New Operator](../../visual-basic/language-reference/operators/new-operator.md)   
 [Access Levels in Visual Basic](../../visual-basic/programming-guide/language-features/declared-elements/access-levels.md)