---
title: "&#39;System.ObsoleteAttribute&#39; cannot be applied to the &#39;AddHandler&#39;, &#39;RemoveHandler&#39;, or &#39;RaiseEvent&#39; definitions | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc31142"
  - "vbc31142"
helpviewer_keywords: 
  - "BC31142"
ms.assetid: 2bddde2e-9ca0-4f72-8910-0789a6350af8
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;System.ObsoleteAttribute&#39; cannot be applied to the &#39;AddHandler&#39;, &#39;RemoveHandler&#39;, or &#39;RaiseEvent&#39; definitions
'System.ObsoleteAttribute' cannot be applied to the 'AddHandler', 'RemoveHandler', or 'RaiseEvent' definitions. If required, apply the attribute directly to the event.  
  
 A custom event applies the <xref:System.ObsoleteAttribute> to its `AddHandler`, `RemoveHandler`, or `RaiseEvent` procedure.  
  
 The <xref:System.ObsoleteAttribute> marks a programming element as no longer in use and informs users that the element is to be removed in future versions of the product.  
  
 It is not meaningful to have certain parts of a custom event still in use while others are no longer in use.  
  
 **Error ID:** BC31142  
  
## To correct this error  
  
-   Remove the <xref:System.ObsoleteAttribute> from the individual procedure declaration and apply it to the overall event declaration.  
  
## See Also  
 <xref:System.ObsoleteAttribute>   
 [Event Statement](../../visual-basic/language-reference/statements/event-statement.md)   
 [AddHandler Statement](../../visual-basic/language-reference/statements/addhandler-statement.md)   
 [RemoveHandler Statement](../../visual-basic/language-reference/statements/removehandler-statement.md)   
 [RaiseEvent Statement](../../visual-basic/language-reference/statements/raiseevent-statement.md)