---
title: "Namespace declaration must start with &#39;xmlns&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc31187"
  - "vbc31187"
helpviewer_keywords: 
  - "BC31187"
ms.assetid: 64c6a033-7cdc-48a0-bff0-bdd045cb13ad
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Namespace declaration must start with &#39;xmlns&#39;
An XML namespace has been specified without the required `xmlns` identifier. The `xmlns` identifier must contain only lowercase characters.  
  
 **Error ID:** BC31187  
  
## To correct this error  
  
-   Use the `xmlns` identifier when you declare an XML namespace. Following is an example:  
  
```vb  
Imports <xmlns:ns="http://SampleNamespace">  
```  
  
## See Also  
 [Imports Statement (XML Namespace)](../../visual-basic/language-reference/statements/imports-statement-xml-namespace.md)   
 [XML Literals](../../visual-basic/language-reference/xml-literals/index.md)   
 [XML](../../visual-basic/programming-guide/language-features/xml/index.md)