---
title: "&#39;&lt;typename&gt;&#39; in assembly &#39;&lt;assemblyname&gt;&#39; has been forwarded to itself and so is an unsupported type | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc31425"
  - "vbc31425"
helpviewer_keywords: 
  - "BC31425"
  - "type forwarding"
ms.assetid: e3275d55-3f4c-4bbc-9c8f-f55c4e973063
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;&lt;typename&gt;&#39; in assembly &#39;&lt;assemblyname&gt;&#39; has been forwarded to itself and so is an unsupported type
An assembly uses the <xref:System.Runtime.CompilerServices.TypeForwardedToAttribute> to forward one of its types to another assembly, but specifies the same type in the same assembly.  
  
 *Type forwarding* means reassigning the definition of a class, structure, interface, delegate, or enumeration to an assembly other than the one in which it was originally defined. It is often used in conjunction with *code refactoring*, by which you split an assembly into two or more assemblies or move code from one assembly to another.  
  
 Forwarding a type to itself results in circular forwarding. If another assembly attempted to access the forwarded type, it would go through endless forwarding without ever arriving at a type that had not been forwarded.  
  
 **Error ID:** BC31425  
  
## To correct this error  
  
-   Forward the type to a type in a different assembly, or do not forward it at all.  
  
## See Also  
 <xref:System.Runtime.CompilerServices.TypeForwardedToAttribute>   
 [Type Forwarding (C++/CLI)](https://docs.microsoft.com/cpp/windows/type-forwarding-cpp-cli)   
 [Managing references in a project](https://docs.microsoft.com/visualstudio/ide/managing-references-in-a-project)   
 [NIB How to: Add or Remove References By Using the Add Reference Dialog Box](http://msdn.microsoft.com/en-us/3bd75d61-f00c-47c0-86a2-dd1f20e231c9)