---
title: "&#39;InterfaceId&#39; and &#39;EventsId&#39; parameters for &#39;Microsoft.VisualBasic.ComClassAttribute&#39; on &#39;&lt;typename&gt;&#39; cannot have the same value | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc32507"
  - "vbc32507"
helpviewer_keywords: 
  - "BC32507"
ms.assetid: 762e2990-e578-492d-b8ee-11658b6069fc
caps.latest.revision: 11
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;InterfaceId&#39; and &#39;EventsId&#39; parameters for &#39;Microsoft.VisualBasic.ComClassAttribute&#39; on &#39;&lt;typename&gt;&#39; cannot have the same value
A `COMClassAttribute` attribute block specifies the same globally unique identifier (GUID) for the interface as for the creation event. If these identifiers are both supplied, they must be different. They must also be different from the class identifier.  
  
 A GUID consists of 16 bytes, of which the first eight are numeric and the last eight are binary. It is generated by Microsoft utilities such as uuidgen.exe and is guaranteed to be unique.  
  
 **Error ID:** BC32507  
  
## To correct this error  
  
1.  Determine the correct GUIDs necessary to identify the interface and creation event for the COM object.  
  
2.  Ensure that the GUID strings presented to the `COMClassAttribute` attribute block are copied correctly.  
  
## See Also  
 [NOT IN BUILD: Attributes Used in Visual Basic](http://msdn.microsoft.com/en-us/22231318-8a40-49af-9245-e0aab723563b)   
 [NOT IN BUILD: Application of Attributes](http://msdn.microsoft.com/en-us/2b1703ed-4437-49b3-bc0b-568094324f47)   
 [ComClassAttribute Class](http://msdn.microsoft.com/en-us/5c2f0835-9210-47dc-bc59-5c1769953574)