---
title: "Nullable modifier cannot be specified in variable declarations with &#39;As New&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc33109"
  - "vbc33109"
helpviewer_keywords: 
  - "BC33109"
ms.assetid: 135def20-3535-4239-bffb-43208d1b3f63
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Nullable modifier cannot be specified in variable declarations with &#39;As New&#39;
The nullable type modifier (?) has been included in a variable declaration where `As New` has been specified. The following example causes this error:  
  
```vb  
Dim num? As New ExampleStructure  
```  
  
 **Error ID:** BC33109  
  
## To correct this error  
  
1.  Remove the `New` keyword from the nullable variable declaration, as shown in the following example:  
  
```vb  
Dim num? As ExampleStructure  
```  
  
## See Also  
 [Nullable Value Types](../../visual-basic/programming-guide/language-features/data-types/nullable-value-types.md)