---
title: "&#39;Using&#39; operand of type &#39;&lt;typename&gt;&#39; must implement System.IDisposable | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36010"
  - "bc36010"
helpviewer_keywords: 
  - "BC36010"
ms.assetid: ae9ed5d5-68ba-4950-bb7a-61327fa0e7d5
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;Using&#39; operand of type &#39;&lt;typename&gt;&#39; must implement System.IDisposable
A `Using` statement specifies a resource of a type that does not implement the <xref:System.IDisposable> interface.  
  
 The purpose of a `Using` block is to guarantee the disposal of a system resource when exiting the block. To satisfy this purpose, the resource must expose the <xref:System.IDisposable.Dispose%2A> method implemented from <xref:System.IDisposable>.  
  
 **Error ID:** BC36010  
  
## To correct this error  
  
-   Remove the resource from the resource list of the `Using` statement, or replace it with a resource that implements <xref:System.IDisposable>.  
  
## See Also  
 <xref:System.IDisposable>   
 [Using Statement](../../visual-basic/language-reference/statements/using-statement.md)   
 [How to: Dispose of a System Resource](../../visual-basic/programming-guide/language-features/control-flow/how-to-dispose-of-a-system-resource.md)