---
title: "Anonymous type member name must be preceded by a period | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36575"
  - "bc36575"
helpviewer_keywords: 
  - "BC36575"
ms.assetid: b87be29e-39f0-4830-9969-608d71137e3e
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Anonymous type member name must be preceded by a period
In the object initializer list for an anonymous type declaration, a new member name to which a value is assigned must be preceded by a period. The following example shows a valid and an invalid declaration:  
  
```vb  
' Valid.  
Dim instanceName1 = New With {.memberName = 10}  
' Invalid declaration that causes this error.  
' Dim instanceName2 = New With {memberName = 10}  
```  
  
 **Error ID:** BC36575  
  
## To correct this error  
  
-   Add a period before the member name.  
  
## See Also  
 [Anonymous Types](../../visual-basic/programming-guide/language-features/objects-and-classes/anonymous-types.md)