---
title: "Method cannot contain both an &#39;On Error GoTo&#39; statement and a lambda or query expression | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36595"
  - "vbc36595"
helpviewer_keywords: 
  - "BC36595"
ms.assetid: 4e7cc11e-f53d-4481-afb4-653a81d54483
caps.latest.revision: 4
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Method cannot contain both an &#39;On Error GoTo&#39; statement and a lambda or query expression
A method contains both an `On Error Goto` statement and either a lambda expression or a LINQ query. You cannot include an `On Error Goto` statement with a lambda expression or LINQ query in a method.  
  
 **Error ID:** BC36595  
  
## To correct this error  
  
1.  Replace the exception handling code that uses the `On Error Goto` statement with a `Try...Catch` statement.  
  
## See Also  
 [Introduction to Exception Handling (Visual Basic)](http://msdn.microsoft.com/en-us/9792f16a-0cd2-40bd-ace2-f7a4344c0e52)   
 [Try...Catch...Finally Statement](../../visual-basic/language-reference/statements/try-catch-finally-statement.md)   
 [Introduction to LINQ in Visual Basic](../../visual-basic/programming-guide/language-features/linq/introduction-to-linq.md)   
 [Lambda Expressions](../../visual-basic/programming-guide/language-features/procedures/lambda-expressions.md)   
 [On Error Statement](../../visual-basic/language-reference/statements/on-error-statement.md)