---
title: "Attributes cannot be applied to parameters of lambda expressions | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36634"
  - "bc36634"
helpviewer_keywords: 
  - "BC36634"
ms.assetid: ed751d8d-11b7-4210-97e0-0319edff8c34
caps.latest.revision: 7
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Attributes cannot be applied to parameters of lambda expressions
You have applied an attribute to a parameter in a lambda expression definition, which is not supported. The following code causes this error.  
  
```vb  
Sub LambaAttribute()  
    ' Not valid.  
    Dim add1 = _  
    Function(<System.Runtime.InteropServices.InAttribute()> m As Integer) _  
                   m + 1  
End Sub  
```  
  
 **Error ID:** BC36634  
  
## To correct this error  
  
-   Remove the attribute, or consider revising your code by changing the lambda expression to a regular function.  
  
## See Also  
 <xref:System.Runtime.InteropServices.InAttribute>   
 [Lambda Expressions](../../visual-basic/programming-guide/language-features/procedures/lambda-expressions.md)   
 [NOT IN BUILD: Attributes in Visual Basic](http://msdn.microsoft.com/en-us/620bfc0e-4582-4c8b-8432-ebc5c3dccc22)