---
title: "Data type(s) of the type parameter(s) in method &#39;&lt;methodname&gt;&#39; cannot be inferred from these arguments because they do not convert to the same type | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36660"
  - "bc36660"
  - "vbc36657"
  - "bc36657"
helpviewer_keywords: 
  - "BC36660"
  - "BC36657"
ms.assetid: e80c5afd-e16d-4f03-bdf1-c79c4286114b
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Data type(s) of the type parameter(s) in method &#39;&lt;methodname&gt;&#39; cannot be inferred from these arguments because they do not convert to the same type
Data type(s) of the type parameter(s) in method '\<methodname>' cannot be inferred from these arguments because they do not convert to the same type. Specifying the data type(s) explicitly might correct this error.  
  
 An attempt has been made to use type inference to determine the data type or types of the type parameter or parameters when evaluating a call to a generic procedure. The compiler could not find a data type that meets the constraints of all the arguments. Therefore, it reported this error.  
  
> [!NOTE]
>  When specifying arguments is not an option (for example, for query operators in query expressions), the error message appears without the second sentence.  
  
 The following code demonstrates the error.  
  
```vb  
Option Strict Off  
Module Module1  
    Sub Main()  
  
        '' Not valid. Integer and Date do not convert to the same type.  
        'targetMethod(19, #3/4/2007#)  
  
    End Sub  
  
    Sub targetMethod(Of T)(ByVal p1 As T, ByVal p2 As T)  
    End Sub  
  
End Module  
```  
  
 **Error ID:** BC36660 and BC36657  
  
## To correct this error  
  
-   You may be able to convert one or more arguments explicitly to a compatible type, as shown in the following code:  
  
    ```  
    targetMethod(19, #3/4/2007#.ToOADate)  
    ```  
  
-   You may be able to specify a data type for the type parameter or parameters to which the arguments convert, as shown in the following code:  
  
    ```  
    targetMethod(Of String)(19, #3/4/2007#)  
    ```  
  
## See Also  
 [Generic Procedures in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-procedures.md)   
 [Type Conversion Functions](../../visual-basic/language-reference/functions/type-conversion-functions.md)   
 [Implicit and Explicit Conversions](../../visual-basic/programming-guide/language-features/data-types/implicit-and-explicit-conversions.md)   
 [Type Conversions in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/type-conversions.md)